/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.support;

import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.soa.support.ServiceRegistryTargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ReferenceFactoryBean<T>
implements FactoryBean<T>,
InitializingBean {
    private ServiceRegistry m_serviceRegistry;
    private Class<T> m_serviceInterface;
    private String m_filter;
    private T m_provider;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.m_serviceRegistry = serviceRegistry;
    }

    public void setServiceInterface(Class<T> serviceInterface) {
        this.m_serviceInterface = serviceInterface;
    }

    public void setFilter(String filter) {
        this.m_filter = filter;
    }

    @Override
    public T getObject() throws Exception {
        if (this.m_provider == null) {
            this.m_provider = ProxyFactory.getProxy(this.m_serviceInterface, new ServiceRegistryTargetSource(this.m_serviceRegistry, this.m_filter, this.m_serviceInterface));
        }
        return this.m_provider;
    }

    @Override
    public Class<? extends T> getObjectType() {
        return this.m_serviceInterface;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.m_serviceRegistry, "The serviceRegistry must be set");
        Assert.notNull(this.m_serviceInterface, "The serviceInterface must be set");
    }
}

