/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InterfacePolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;

public class TablePerClassPolicy
extends InterfacePolicy
implements Serializable,
Cloneable {
    protected HashMap<DatabaseMapping, DatabaseQuery> selectionQueriesForAllObjects;

    public TablePerClassPolicy(ClassDescriptor descriptor) {
        this.setDescriptor(descriptor);
        this.selectionQueriesForAllObjects = new HashMap();
    }

    protected void addSelectionQuery(ForeignReferenceMapping cloneMapping, ForeignReferenceMapping sourceMapping, AbstractSession session) {
        cloneMapping.setReferenceClass(this.getDescriptor().getJavaClass());
        cloneMapping.setReferenceClassName(this.getDescriptor().getJavaClassName());
        cloneMapping.setForceInitializationOfSelectionCriteria(true);
        cloneMapping.initialize(session);
        ObjectLevelReadQuery selectionQuery = (ObjectLevelReadQuery)cloneMapping.getSelectionQuery();
        selectionQuery.getExpressionBuilder().setQueryClassAndDescriptor(this.descriptor.getJavaClass(), this.descriptor);
        selectionQuery.setSourceMapping(sourceMapping);
        this.selectionQueriesForAllObjects.put(sourceMapping, selectionQuery);
    }

    @Override
    public boolean isTablePerClassPolicy() {
        return true;
    }

    public void prepareChildrenSelectionQuery(DatabaseMapping sourceMapping, AbstractSession session) {
        for (ClassDescriptor childDescriptor : this.getChildDescriptors()) {
            childDescriptor.getTablePerClassPolicy().prepareSelectionQuery(sourceMapping, session);
        }
    }

    protected void prepareManyToManySelectionQuery(ManyToManyMapping sourceMapping, AbstractSession session) {
        ManyToManyMapping manyToMany = (ManyToManyMapping)sourceMapping.clone();
        for (DatabaseField keyField : manyToMany.getTargetKeyFields()) {
            keyField.setTable(new DatabaseTable());
        }
        this.addSelectionQuery(manyToMany, sourceMapping, session);
    }

    protected void prepareOneToManySelectionQuery(OneToManyMapping sourceMapping, AbstractSession session) {
        OneToManyMapping oneToMany = (OneToManyMapping)sourceMapping.clone();
        Vector<DatabaseField> targetForeignKeyFields = new Vector<DatabaseField>();
        for (DatabaseField fkField : oneToMany.getTargetForeignKeysToSourceKeys().keySet()) {
            targetForeignKeyFields.add(new DatabaseField(fkField.getName()));
        }
        oneToMany.setTargetForeignKeyFields(targetForeignKeyFields);
        oneToMany.getTargetForeignKeysToSourceKeys().clear();
        oneToMany.getSourceKeysToTargetForeignKeys().clear();
        this.addSelectionQuery(oneToMany, sourceMapping, session);
    }

    protected void prepareOneToOneSelectionQuery(OneToOneMapping sourceMapping, AbstractSession session) {
        OneToOneMapping oneToOne = (OneToOneMapping)sourceMapping.clone();
        for (DatabaseField targetField : oneToOne.getTargetToSourceKeyFields().keySet()) {
            targetField.setTable(new DatabaseTable());
        }
        this.addSelectionQuery(oneToOne, sourceMapping, session);
    }

    protected void prepareSelectionQuery(DatabaseMapping sourceMapping, AbstractSession session) {
        for (ClassDescriptor childDescriptor : this.getChildDescriptors()) {
            childDescriptor.getTablePerClassPolicy().prepareSelectionQuery(sourceMapping, session);
        }
        if (sourceMapping.isOneToManyMapping()) {
            this.prepareOneToManySelectionQuery((OneToManyMapping)sourceMapping, session);
        } else if (sourceMapping.isManyToManyMapping()) {
            this.prepareManyToManySelectionQuery((ManyToManyMapping)sourceMapping, session);
        } else if (sourceMapping.isOneToOneMapping()) {
            this.prepareOneToOneSelectionQuery((OneToOneMapping)sourceMapping, session);
        }
    }

    @Override
    protected Object selectAllObjects(ReadAllQuery query) {
        if (this.descriptor.isAbstract()) {
            return query.getContainerPolicy().containerInstance();
        }
        if (this.selectionQueriesForAllObjects.containsKey(query.getSourceMapping())) {
            return query.getExecutionSession().executeQuery(this.selectionQueriesForAllObjects.get(query.getSourceMapping()), query.getTranslationRow());
        }
        return super.selectAllObjects(query);
    }

    @Override
    protected Object selectOneObject(ReadObjectQuery query) throws DescriptorException {
        if (this.descriptor.isAbstract()) {
            return null;
        }
        if (this.selectionQueriesForAllObjects.containsKey(query.getSourceMapping())) {
            return query.getExecutionSession().executeQuery(this.selectionQueriesForAllObjects.get(query.getSourceMapping()), query.getTranslationRow());
        }
        AbstractRecord translationRow = query.getTranslationRow().clone();
        Vector<DatabaseField> allFields = new Vector<DatabaseField>();
        for (DatabaseField field : translationRow.getFields()) {
            allFields.add(new DatabaseField(field.getName()));
        }
        translationRow.getFields().clear();
        translationRow.getFields().addAll(allFields);
        return query.getSession().executeQuery((DatabaseQuery)this.getDescriptor().getQueryManager().getReadObjectQuery(), translationRow);
    }
}

