/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.grafana;

import java.time.ZoneId;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.opennms.netmgt.endpoints.grafana.api.Dashboard;
import org.opennms.netmgt.endpoints.grafana.api.GrafanaClient;
import org.opennms.netmgt.endpoints.grafana.api.Panel;
import org.opennms.netmgt.jasper.grafana.ExceptionToPngRenderer;
import org.opennms.netmgt.jasper.grafana.GrafanaQuery;
import org.opennms.netmgt.jasper.helper.TimezoneHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrafanaPanelDatasource
implements JRRewindableDataSource {
    private static final Logger LOG = LoggerFactory.getLogger(GrafanaPanelDatasource.class);
    public static final String IMAGE_FIELD_NAME = "png";
    public static final String WIDTH_FIELD_NAME = "width";
    public static final String HEIGHT_FIELD_NAME = "height";
    public static final String TITLE_FIELD_NAME = "title";
    public static final String DATASOURCE_FIELD_NAME = "datasource";
    public static final String DESCRIPTION_FIELD_NAME = "description";
    private final GrafanaClient client;
    private final Dashboard dashboard;
    private final GrafanaQuery query;
    private final List<Panel> panels;
    private Iterator<Panel> iterator;
    private Panel currentPanel;
    private Map<Panel, CompletableFuture<byte[]>> panelRenders;

    public GrafanaPanelDatasource(GrafanaClient client, Dashboard dashboard, GrafanaQuery query) {
        this.client = Objects.requireNonNull(client);
        this.dashboard = Objects.requireNonNull(dashboard);
        this.query = Objects.requireNonNull(query);
        this.panels = dashboard.getPanels().stream().flatMap(p -> {
            if ("row".equals(p.getType())) {
                return p.getPanels().stream();
            }
            return Stream.of(p);
        }).collect(Collectors.toList());
        this.moveFirst();
    }

    public void moveFirst() {
        this.iterator = this.panels.iterator();
    }

    public boolean next() {
        if (!this.iterator.hasNext()) {
            return false;
        }
        this.currentPanel = this.iterator.next();
        return true;
    }

    public Object getFieldValue(JRField jrField) {
        String fieldName = jrField.getName();
        if (Objects.equals(WIDTH_FIELD_NAME, fieldName)) {
            return this.query.getWidth();
        }
        if (Objects.equals(HEIGHT_FIELD_NAME, fieldName)) {
            return this.query.getHeight();
        }
        if (Objects.equals(TITLE_FIELD_NAME, fieldName)) {
            return this.currentPanel.getTitle();
        }
        if (Objects.equals(DATASOURCE_FIELD_NAME, fieldName)) {
            return this.currentPanel.getDatasource();
        }
        if (Objects.equals(DESCRIPTION_FIELD_NAME, fieldName)) {
            return this.currentPanel.getDescription();
        }
        if (Objects.equals(IMAGE_FIELD_NAME, fieldName)) {
            try {
                this.maybeRenderPanels();
                LOG.debug("Waiting for panel with id: {} on dashboard with uid: {} to finish rendering.", (Object)this.currentPanel.getId(), (Object)this.dashboard.getUid());
                byte[] pngBytes = this.panelRenders.get(this.currentPanel).get(5L, TimeUnit.MINUTES);
                LOG.debug("PNG successfully rendered ({} bytes) for panel with id: {} on dashboard with uid: {}", pngBytes.length, this.currentPanel.getId(), this.dashboard.getUid());
                return pngBytes;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOG.warn("Exception while rendering panel with id: {} on dashboard with uid: {}", this.currentPanel.getId(), this.dashboard.getUid(), e);
                return ExceptionToPngRenderer.renderExceptionToPng(e);
            }
        }
        return "<unknown field name: " + fieldName + ">";
    }

    private void maybeRenderPanels() {
        if (this.panelRenders != null) {
            return;
        }
        this.panelRenders = new HashMap<Panel, CompletableFuture<byte[]>>();
        LOG.debug("Triggering asynchronous rendering of PNGs for {} panels for dashboard: {}", (Object)this.panels.size(), (Object)this.dashboard.getTitle());
        String utcOffset = GrafanaPanelDatasource.getUtcOffset(this.query);
        for (Panel panel : this.panels) {
            CompletableFuture<byte[]> panelImageBytes = this.client.renderPngForPanel(this.dashboard, panel, this.query.getWidth(), this.query.getHeight(), this.query.getFrom().getTime(), this.query.getTo().getTime(), utcOffset, this.query.getVariables());
            this.panelRenders.put(panel, panelImageBytes);
        }
    }

    private static String getUtcOffset(GrafanaQuery query) {
        if (query.getTimezone() != null) {
            ZoneId zoneId = ZoneId.of(query.getTimezone());
            String utcOffset = TimezoneHelper.getUtcOffset(zoneId, query.getFrom());
            return utcOffset;
        }
        return null;
    }
}

