/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.spring;

import org.springframework.beans.BeanWrapper;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyAccessorUtils;

public class PropertyPath {
    private PropertyPath parent = null;
    private String propertyName;
    private String key;

    public PropertyPath(String nestedPath) {
        String canonicalPath = PropertyAccessorUtils.canonicalPropertyName(nestedPath);
        int lastIndex = PropertyAccessorUtils.getLastNestedPropertySeparatorIndex(canonicalPath);
        if (lastIndex < 0) {
            this.propertyName = PropertyAccessorUtils.getPropertyName(canonicalPath);
            this.key = this.computeKey(canonicalPath);
        } else {
            this.parent = new PropertyPath(canonicalPath.substring(0, lastIndex));
            String lastProperty = canonicalPath.substring(lastIndex + 1);
            this.propertyName = PropertyAccessorUtils.getPropertyName(lastProperty);
            this.key = this.computeKey(lastProperty);
        }
    }

    private String computeKey(String property) {
        int keyPrefix = property.indexOf(91);
        if (keyPrefix < 0) {
            return "";
        }
        int keySuffix = property.indexOf(93);
        return property.substring(keyPrefix + 1, keySuffix);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.parent == null ? "" : this.parent.toString() + '.');
        buf.append(this.propertyName);
        if (this.key.length() > 0) {
            buf.append("[");
            buf.append(this.key);
            buf.append("]");
        }
        return buf.toString();
    }

    public String getKey() {
        return this.key;
    }

    public PropertyPath getParent() {
        return this.parent;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getValue(Object root) throws InvalidPropertyException {
        return this.getValue(PropertyAccessorFactory.forBeanPropertyAccess(root));
    }

    public Object getValue(BeanWrapper beanWrapper) throws InvalidPropertyException {
        return beanWrapper.getPropertyValue(this.toString());
    }
}

