/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.helper;

import org.opennms.netmgt.measurements.api.ExpressionEngine;
import org.opennms.netmgt.measurements.api.FilterEngine;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringHelper
implements ApplicationContextAware {
    private static Logger LOG = LoggerFactory.getLogger(SpringHelper.class);
    private ApplicationContext applicationContext;

    public MeasurementFetchStrategy getMeasurementFetchStrategy() {
        return this.getBean("measurementFetchStrategy", MeasurementFetchStrategy.class);
    }

    public ExpressionEngine getExpressionEngine() {
        return this.getBean("expressionEngine", ExpressionEngine.class);
    }

    public FilterEngine getFilterEngine() {
        return this.getBean("filterEngine", FilterEngine.class);
    }

    public <T> T getBean(String name, Class<T> clazz) {
        if (this.applicationContext == null) {
            LOG.error("Could not instantiate bean with name '{}' and type '{}'. ApplicationContext is '{}'", name, clazz, this.applicationContext);
            return null;
        }
        try {
            return this.applicationContext.getBean(name, clazz);
        }
        catch (Exception ex) {
            LOG.error("Could not instantiate bean with name '{}' and type '{}'", name, clazz, ex);
            return null;
        }
    }

    public ApplicationContext getSpringContext() {
        return this.applicationContext;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

