/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.spring;

import java.io.File;
import java.io.IOException;
import org.opennms.core.spring.FileReloadCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

public class FileReloadContainer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FileReloadContainer.class);
    private static final long DEFAULT_RELOAD_CHECK_INTERVAL = 1000L;
    private T m_object;
    private Resource m_resource;
    private File m_file;
    private long m_lastModified;
    private long m_lastFileSize;
    private FileReloadCallback<T> m_callback;
    private long m_reloadCheckInterval = 1000L;
    private long m_lastReloadCheck;
    private long m_lastUpdate;

    public FileReloadContainer(T object, Resource resource, FileReloadCallback<T> callback) {
        Assert.notNull(object, "argument object cannot be null");
        Assert.notNull(resource, "argument file cannot be null");
        Assert.notNull(callback, "argument callback cannot be null");
        this.m_object = object;
        this.m_resource = resource;
        this.m_callback = callback;
        try {
            this.m_file = resource.getFile();
            this.m_lastModified = this.m_file.lastModified();
            this.m_lastFileSize = this.m_file.length();
        }
        catch (IOException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Resource '{}' does not seem to have an underlying File object; assuming this is not an auto-reloadable file resource", (Object)resource, (Object)e);
            }
            LOG.info("Resource '{}' does not seem to have an underlying File object; assuming this is not an auto-reloadable file resource", (Object)resource);
        }
        this.m_lastReloadCheck = System.currentTimeMillis();
    }

    public FileReloadContainer(File file, FileReloadCallback<T> callback) {
        this.m_object = null;
        this.m_resource = new FileSystemResource(file);
        this.m_file = file;
        this.m_callback = callback;
        this.m_lastModified = -1L;
        this.m_lastFileSize = -1L;
    }

    public FileReloadContainer(T object) {
        Assert.notNull(object, "argument object cannot be null");
        this.m_object = object;
    }

    public T getObject() throws DataAccessResourceFailureException {
        this.checkForUpdates();
        return this.m_object;
    }

    private synchronized void checkForUpdates() throws DataAccessResourceFailureException {
        if (this.m_file == null || this.m_reloadCheckInterval < 0L || System.currentTimeMillis() < this.m_lastReloadCheck + this.m_reloadCheckInterval) {
            return;
        }
        this.m_lastReloadCheck = System.currentTimeMillis();
        if (this.m_file.lastModified() <= this.m_lastModified && this.m_file.length() == this.m_lastFileSize) {
            return;
        }
        this.reload();
    }

    public synchronized void reload() {
        T object;
        this.m_lastModified = this.m_file.lastModified();
        this.m_lastFileSize = this.m_file.length();
        try {
            object = this.m_callback.reload(this.m_object, this.m_resource);
        }
        catch (Throwable t) {
            String message = String.format("Failed reloading data for object '%s' from file '%s'. Unexpected Throwable received while issuing reload.", this.m_object, this.m_file.getAbsolutePath());
            LOG.error(message, t);
            throw new DataAccessResourceFailureException(message, t);
        }
        if (object == null) {
            LOG.info("Not updating object for file '{}' due to reload callback returning null.", (Object)this.m_file.getAbsolutePath());
        } else {
            this.m_object = object;
        }
        this.m_lastUpdate = System.currentTimeMillis();
    }

    public File getFile() {
        return this.m_file;
    }

    public long getReloadCheckInterval() {
        return this.m_reloadCheckInterval;
    }

    public void setReloadCheckInterval(long reloadCheckInterval) {
        this.m_reloadCheckInterval = reloadCheckInterval;
    }

    public long getLastUpdate() {
        return this.m_lastUpdate;
    }
}

