/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.api.FilterInfo;
import org.opennms.netmgt.measurements.api.FilterParam;
import org.opennms.netmgt.measurements.model.FilterParamMetaData;

@XmlRootElement(name="filter")
@XmlAccessorType(value=XmlAccessType.NONE)
public class FilterMetaData {
    @XmlAttribute(name="canonicalName", required=true)
    private String canonicalName;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="description")
    private String description;
    @XmlAttribute(name="backend")
    private String backend;
    @XmlElement(name="parameter")
    private List<FilterParamMetaData> parameters;

    public FilterMetaData() {
    }

    public FilterMetaData(Class<? extends Filter> type) {
        Preconditions.checkNotNull(type, "type argument");
        FilterInfo info = type.getAnnotation(FilterInfo.class);
        Preconditions.checkState(info != null, "Filters must be annotated with FilterInfo.");
        this.canonicalName = type.getCanonicalName();
        this.name = info.name();
        this.description = info.description();
        this.backend = info.backend();
        this.parameters = Lists.newArrayList();
        for (Field field : type.getDeclaredFields()) {
            FilterParam filterParam = field.getAnnotation(FilterParam.class);
            if (filterParam == null) continue;
            this.parameters.add(new FilterParamMetaData(field, filterParam));
        }
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBackend() {
        return this.backend;
    }

    public List<FilterParamMetaData> getParameters() {
        return this.parameters;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public void setParameters(List<FilterParamMetaData> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterMetaData other = (FilterMetaData)obj;
        return Objects.equal(this.canonicalName, other.canonicalName) && Objects.equal(this.name, other.name) && Objects.equal(this.description, other.description) && Objects.equal(this.backend, other.backend) && Objects.equal(this.parameters, other.parameters);
    }

    public int hashCode() {
        return Objects.hashCode(this.canonicalName, this.name, this.description, this.backend, this.parameters);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("CanonicalName", this.canonicalName).add("Name", this.name).add("Description", this.description).add("Backend", this.backend).add("Parameters", this.parameters).toString();
    }
}

