/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.api;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.TreeBasedTable;
import java.util.Arrays;
import java.util.Map;

public class FetchResults {
    private final long[] m_timestamps;
    private final Map<String, double[]> m_columns;
    private final long m_step;
    private final Map<String, Object> m_constants;

    public FetchResults(long[] timestamps, Map<String, double[]> columns, long step, Map<String, Object> constants) {
        Preconditions.checkNotNull(timestamps, "timestamps argument");
        Preconditions.checkNotNull(columns, "columns argument");
        Preconditions.checkNotNull(constants, "constants argument");
        this.m_timestamps = timestamps;
        this.m_columns = columns;
        this.m_step = step;
        this.m_constants = constants;
    }

    public FetchResults(RowSortedTable<Long, String, Double> table, long step, Map<String, Object> constants) {
        Preconditions.checkNotNull(table, "table argument");
        Preconditions.checkNotNull(constants, "constants argument");
        this.m_step = step;
        this.m_constants = constants;
        if (table.size() < 1) {
            this.m_timestamps = new long[0];
            this.m_columns = Maps.newHashMapWithExpectedSize(0);
            return;
        }
        Long firstIndex = null;
        Long lastIndex = null;
        Map timestampsByIndex = table.column("timestamp");
        for (Long index : timestampsByIndex.keySet()) {
            if (firstIndex == null) {
                firstIndex = index;
            } else {
                Preconditions.checkState(index == lastIndex + 1L, "filter timestamps must be contiguous");
            }
            lastIndex = index;
        }
        int numRows = (int)(lastIndex - firstIndex) + 1;
        this.m_columns = Maps.newLinkedHashMap();
        this.m_timestamps = new long[numRows];
        for (String columnName : table.columnKeySet()) {
            Map columnMap = table.column(columnName);
            if ("timestamp".equals(columnName)) {
                for (int k = 0; k < numRows; ++k) {
                    Double value = (Double)columnMap.get(k);
                    Preconditions.checkNotNull(value, "filter timestamps must be contiguous");
                    this.m_timestamps[k] = value.longValue();
                }
                continue;
            }
            double[] column = new double[numRows];
            this.m_columns.put(columnName, column);
            for (int k = 0; k < numRows; ++k) {
                Double value = (Double)columnMap.get(k);
                column[k] = value == null ? Double.NaN : value;
            }
        }
    }

    public long[] getTimestamps() {
        return this.m_timestamps;
    }

    public Map<String, double[]> getColumns() {
        return this.m_columns;
    }

    public long getStep() {
        return this.m_step;
    }

    public Map<String, Object> getConstants() {
        return this.m_constants;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("timestamps", Arrays.toString(this.m_timestamps)).add("columns", this.m_columns).add("step", this.m_step).add("constants", this.m_constants).toString();
    }

    public RowSortedTable<Long, String, Double> asRowSortedTable() {
        TreeBasedTable<Long, String, Double> table = TreeBasedTable.create();
        for (int i = 0; i < this.m_timestamps.length; ++i) {
            table.put(Long.valueOf(i), "timestamp", Double.valueOf(this.m_timestamps[i]));
            for (String column : this.m_columns.keySet()) {
                table.put(Long.valueOf(i), column, this.m_columns.get(column)[i]);
            }
        }
        return table;
    }
}

