/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.ExpressionInvocationTargetException;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.FormatHelper;
import org.springframework.expression.spel.ast.SpelNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodReference
extends SpelNodeImpl {
    private final String name;
    private final boolean nullSafe;
    private volatile MethodExecutor cachedExecutor;

    public MethodReference(boolean nullSafe, String methodName, int pos, SpelNodeImpl ... arguments) {
        super(pos, arguments);
        this.name = methodName;
        this.nullSafe = nullSafe;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypedValue currentContext = state.getActiveContextObject();
        Object[] arguments = new Object[this.getChildCount()];
        int i = 0;
        while (i < arguments.length) {
            try {
                state.pushActiveContextObject(state.getRootContextObject());
                arguments[i] = this.children[i].getValueInternal(state).getValue();
            }
            finally {
                state.popActiveContextObject();
            }
            ++i;
        }
        if (currentContext.getValue() == null) {
            if (this.nullSafe) {
                return TypedValue.NULL;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.METHOD_CALL_ON_NULL_OBJECT_NOT_ALLOWED, FormatHelper.formatMethodForMessage(this.name, this.getTypes(arguments)));
        }
        MethodExecutor executorToUse = this.cachedExecutor;
        if (executorToUse != null) {
            try {
                return executorToUse.execute(state.getEvaluationContext(), state.getActiveContextObject().getValue(), arguments);
            }
            catch (AccessException ae) {
                this.throwSimpleExceptionIfPossible(state, ae);
                this.cachedExecutor = null;
            }
        }
        this.cachedExecutor = executorToUse = this.findAccessorForMethod(this.name, this.getTypes(arguments), state);
        try {
            return executorToUse.execute(state.getEvaluationContext(), state.getActiveContextObject().getValue(), arguments);
        }
        catch (AccessException ae) {
            this.throwSimpleExceptionIfPossible(state, ae);
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ae, SpelMessage.EXCEPTION_DURING_METHOD_INVOCATION, this.name, state.getActiveContextObject().getValue().getClass().getName(), ae.getMessage());
        }
    }

    private void throwSimpleExceptionIfPossible(ExpressionState state, AccessException ae) {
        Throwable rootCause;
        Throwable causeOfAccessException = ae.getCause();
        Throwable throwable = rootCause = causeOfAccessException == null ? null : causeOfAccessException.getCause();
        if (rootCause != null) {
            if (rootCause instanceof RuntimeException) {
                throw (RuntimeException)rootCause;
            }
            throw new ExpressionInvocationTargetException(this.getStartPosition(), "A problem occurred when trying to execute method '" + this.name + "' on object of type '" + state.getActiveContextObject().getValue().getClass().getName() + "'", rootCause);
        }
    }

    private List<TypeDescriptor> getTypes(Object ... arguments) {
        ArrayList<TypeDescriptor> descriptors = new ArrayList<TypeDescriptor>(arguments.length);
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Object argument = objectArray[n2];
            descriptors.add(TypeDescriptor.forObject(argument));
            ++n2;
        }
        return descriptors;
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("(");
        int i = 0;
        while (i < this.getChildCount()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getChild(i).toStringAST());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private MethodExecutor findAccessorForMethod(String name, List<TypeDescriptor> argumentTypes, ExpressionState state) throws SpelEvaluationException {
        TypedValue context = state.getActiveContextObject();
        Object contextObject = context.getValue();
        EvaluationContext eContext = state.getEvaluationContext();
        List<MethodResolver> mResolvers = eContext.getMethodResolvers();
        if (mResolvers != null) {
            for (MethodResolver methodResolver : mResolvers) {
                try {
                    MethodExecutor cEx = methodResolver.resolve(state.getEvaluationContext(), contextObject, name, argumentTypes);
                    if (cEx == null) continue;
                    return cEx;
                }
                catch (AccessException ex) {
                    throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.PROBLEM_LOCATING_METHOD, name, contextObject.getClass());
                }
            }
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.METHOD_NOT_FOUND, FormatHelper.formatMethodForMessage(name, argumentTypes), FormatHelper.formatClassNameForMessage(contextObject instanceof Class ? (Class<?>)contextObject : contextObject.getClass()));
    }
}

