/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.weaver.tools.PointcutParser;
import org.aspectj.weaver.tools.PointcutPrimitive;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectJAdviceParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private static final String THIS_JOIN_POINT = "thisJoinPoint";
    private static final String THIS_JOIN_POINT_STATIC_PART = "thisJoinPointStaticPart";
    private static final int STEP_JOIN_POINT_BINDING = 1;
    private static final int STEP_THROWING_BINDING = 2;
    private static final int STEP_ANNOTATION_BINDING = 3;
    private static final int STEP_RETURNING_BINDING = 4;
    private static final int STEP_PRIMITIVE_ARGS_BINDING = 5;
    private static final int STEP_THIS_TARGET_ARGS_BINDING = 6;
    private static final int STEP_REFERENCE_PCUT_BINDING = 7;
    private static final int STEP_FINISHED = 8;
    private static final Set<String> singleValuedAnnotationPcds = new HashSet<String>();
    private static final Set<String> nonReferencePointcutTokens = new HashSet<String>();
    private boolean raiseExceptions;
    private String returningName;
    private String throwingName;
    private String pointcutExpression;
    private Class[] argumentTypes;
    private String[] parameterNameBindings;
    private int numberOfRemainingUnboundArguments;

    static {
        singleValuedAnnotationPcds.add("@this");
        singleValuedAnnotationPcds.add("@target");
        singleValuedAnnotationPcds.add("@within");
        singleValuedAnnotationPcds.add("@withincode");
        singleValuedAnnotationPcds.add("@annotation");
        Set pointcutPrimitives = PointcutParser.getAllSupportedPointcutPrimitives();
        for (PointcutPrimitive primitive : pointcutPrimitives) {
            nonReferencePointcutTokens.add(primitive.getName());
        }
        nonReferencePointcutTokens.add("&&");
        nonReferencePointcutTokens.add("!");
        nonReferencePointcutTokens.add("||");
        nonReferencePointcutTokens.add("and");
        nonReferencePointcutTokens.add("or");
        nonReferencePointcutTokens.add("not");
    }

    public AspectJAdviceParameterNameDiscoverer(String pointcutExpression) {
        this.pointcutExpression = pointcutExpression;
    }

    public void setRaiseExceptions(boolean raiseExceptions) {
        this.raiseExceptions = raiseExceptions;
    }

    public void setReturningName(String returningName) {
        this.returningName = returningName;
    }

    public void setThrowingName(String throwingName) {
        this.throwingName = throwingName;
    }

    @Override
    public String[] getParameterNames(Method method) {
        this.argumentTypes = method.getParameterTypes();
        this.numberOfRemainingUnboundArguments = this.argumentTypes.length;
        this.parameterNameBindings = new String[this.numberOfRemainingUnboundArguments];
        int minimumNumberUnboundArgs = 0;
        if (this.returningName != null) {
            ++minimumNumberUnboundArgs;
        }
        if (this.throwingName != null) {
            ++minimumNumberUnboundArgs;
        }
        if (this.numberOfRemainingUnboundArguments < minimumNumberUnboundArgs) {
            throw new IllegalStateException("Not enough arguments in method to satisfy binding of returning and throwing variables");
        }
        try {
            int algorithmicStep = 1;
            block12: while (this.numberOfRemainingUnboundArguments > 0 && algorithmicStep < 8) {
                switch (algorithmicStep++) {
                    case 1: {
                        if (this.maybeBindThisJoinPoint()) continue block12;
                        this.maybeBindThisJoinPointStaticPart();
                        break;
                    }
                    case 2: {
                        this.maybeBindThrowingVariable();
                        break;
                    }
                    case 3: {
                        this.maybeBindAnnotationsFromPointcutExpression();
                        break;
                    }
                    case 4: {
                        this.maybeBindReturningVariable();
                        break;
                    }
                    case 5: {
                        this.maybeBindPrimitiveArgsFromPointcutExpression();
                        break;
                    }
                    case 6: {
                        this.maybeBindThisOrTargetOrArgsFromPointcutExpression();
                        break;
                    }
                    case 7: {
                        this.maybeBindReferencePointcutParameter();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown algorithmic step: " + (algorithmicStep - 1));
                    }
                }
            }
        }
        catch (AmbiguousBindingException ambigEx) {
            if (this.raiseExceptions) {
                throw ambigEx;
            }
            return null;
        }
        catch (IllegalArgumentException ex) {
            if (this.raiseExceptions) {
                throw ex;
            }
            return null;
        }
        if (this.numberOfRemainingUnboundArguments == 0) {
            return this.parameterNameBindings;
        }
        if (this.raiseExceptions) {
            throw new IllegalStateException("Failed to bind all argument names: " + this.numberOfRemainingUnboundArguments + " argument(s) could not be bound");
        }
        return null;
    }

    @Override
    public String[] getParameterNames(Constructor ctor) {
        if (this.raiseExceptions) {
            throw new UnsupportedOperationException("An advice method can never be a constructor");
        }
        return null;
    }

    private void bindParameterName(int index, String name) {
        this.parameterNameBindings[index] = name;
        --this.numberOfRemainingUnboundArguments;
    }

    private boolean maybeBindThisJoinPoint() {
        if (this.argumentTypes[0] == JoinPoint.class || this.argumentTypes[0] == ProceedingJoinPoint.class) {
            this.bindParameterName(0, THIS_JOIN_POINT);
            return true;
        }
        return false;
    }

    private void maybeBindThisJoinPointStaticPart() {
        if (this.argumentTypes[0] == JoinPoint.StaticPart.class) {
            this.bindParameterName(0, THIS_JOIN_POINT_STATIC_PART);
        }
    }

    private void maybeBindThrowingVariable() {
        if (this.throwingName == null) {
            return;
        }
        int throwableIndex = -1;
        int i = 0;
        while (i < this.argumentTypes.length) {
            if (this.isUnbound(i) && this.isSubtypeOf(Throwable.class, i)) {
                if (throwableIndex == -1) {
                    throwableIndex = i;
                } else {
                    throw new AmbiguousBindingException("Binding of throwing parameter '" + this.throwingName + "' is ambiguous: could be bound to argument " + throwableIndex + " or argument " + i);
                }
            }
            ++i;
        }
        if (throwableIndex == -1) {
            throw new IllegalStateException("Binding of throwing parameter '" + this.throwingName + "' could not be completed as no available arguments are a subtype of Throwable");
        }
        this.bindParameterName(throwableIndex, this.throwingName);
    }

    private void maybeBindReturningVariable() {
        if (this.numberOfRemainingUnboundArguments == 0) {
            throw new IllegalStateException("Algorithm assumes that there must be at least one unbound parameter on entry to this method");
        }
        if (this.returningName != null) {
            if (this.numberOfRemainingUnboundArguments > 1) {
                throw new AmbiguousBindingException("Binding of returning parameter '" + this.returningName + "' is ambiguous, there are " + this.numberOfRemainingUnboundArguments + " candidates.");
            }
            int i = 0;
            while (i < this.parameterNameBindings.length) {
                if (this.parameterNameBindings[i] == null) {
                    this.bindParameterName(i, this.returningName);
                    break;
                }
                ++i;
            }
        }
    }

    private void maybeBindAnnotationsFromPointcutExpression() {
        ArrayList<String> varNames = new ArrayList<String>();
        String[] tokens = StringUtils.tokenizeToStringArray(this.pointcutExpression, " ");
        int i = 0;
        while (i < tokens.length) {
            PointcutBody body;
            String toMatch = tokens[i];
            int firstParenIndex = toMatch.indexOf("(");
            if (firstParenIndex != -1) {
                toMatch = toMatch.substring(0, firstParenIndex);
            }
            if (singleValuedAnnotationPcds.contains(toMatch)) {
                body = this.getPointcutBody(tokens, i);
                i += body.numTokensConsumed;
                String varName = this.maybeExtractVariableName(body.text);
                if (varName != null) {
                    varNames.add(varName);
                }
            } else if (tokens[i].startsWith("@args(") || tokens[i].equals("@args")) {
                body = this.getPointcutBody(tokens, i);
                i += body.numTokensConsumed;
                this.maybeExtractVariableNamesFromArgs(body.text, varNames);
            }
            ++i;
        }
        this.bindAnnotationsFromVarNames(varNames);
    }

    private void bindAnnotationsFromVarNames(List<String> varNames) {
        if (!varNames.isEmpty()) {
            int numAnnotationSlots = this.countNumberOfUnboundAnnotationArguments();
            if (numAnnotationSlots > 1) {
                throw new AmbiguousBindingException("Found " + varNames.size() + " potential annotation variable(s), and " + numAnnotationSlots + " potential argument slots");
            }
            if (numAnnotationSlots == 1) {
                if (varNames.size() == 1) {
                    this.findAndBind(Annotation.class, varNames.get(0));
                } else {
                    throw new IllegalArgumentException("Found " + varNames.size() + " candidate annotation binding variables" + " but only one potential argument binding slot");
                }
            }
        }
    }

    private String maybeExtractVariableName(String candidateToken) {
        if (candidateToken == null || candidateToken.equals("")) {
            return null;
        }
        if (Character.isJavaIdentifierStart(candidateToken.charAt(0)) && Character.isLowerCase(candidateToken.charAt(0))) {
            char[] tokenChars;
            char[] cArray = tokenChars = candidateToken.toCharArray();
            int n = tokenChars.length;
            int n2 = 0;
            while (n2 < n) {
                char tokenChar = cArray[n2];
                if (!Character.isJavaIdentifierPart(tokenChar)) {
                    return null;
                }
                ++n2;
            }
            return candidateToken;
        }
        return null;
    }

    private void maybeExtractVariableNamesFromArgs(String argsSpec, List<String> varNames) {
        if (argsSpec == null) {
            return;
        }
        String[] tokens = StringUtils.tokenizeToStringArray(argsSpec, ",");
        int i = 0;
        while (i < tokens.length) {
            tokens[i] = StringUtils.trimWhitespace(tokens[i]);
            String varName = this.maybeExtractVariableName(tokens[i]);
            if (varName != null) {
                varNames.add(varName);
            }
            ++i;
        }
    }

    private void maybeBindThisOrTargetOrArgsFromPointcutExpression() {
        if (this.numberOfRemainingUnboundArguments > 1) {
            throw new AmbiguousBindingException("Still " + this.numberOfRemainingUnboundArguments + " unbound args at this(),target(),args() binding stage, with no way to determine between them");
        }
        ArrayList<String> varNames = new ArrayList<String>();
        String[] tokens = StringUtils.tokenizeToStringArray(this.pointcutExpression, " ");
        int i = 0;
        while (i < tokens.length) {
            PointcutBody body;
            if (tokens[i].equals("this") || tokens[i].startsWith("this(") || tokens[i].equals("target") || tokens[i].startsWith("target(")) {
                body = this.getPointcutBody(tokens, i);
                i += body.numTokensConsumed;
                String varName = this.maybeExtractVariableName(body.text);
                if (varName != null) {
                    varNames.add(varName);
                }
            } else if (tokens[i].equals("args") || tokens[i].startsWith("args(")) {
                body = this.getPointcutBody(tokens, i);
                i += body.numTokensConsumed;
                ArrayList<String> candidateVarNames = new ArrayList<String>();
                this.maybeExtractVariableNamesFromArgs(body.text, candidateVarNames);
                for (String varName : candidateVarNames) {
                    if (this.alreadyBound(varName)) continue;
                    varNames.add(varName);
                }
            }
            ++i;
        }
        if (varNames.size() > 1) {
            throw new AmbiguousBindingException("Found " + varNames.size() + " candidate this(), target() or args() variables but only one unbound argument slot");
        }
        if (varNames.size() == 1) {
            int j = 0;
            while (j < this.parameterNameBindings.length) {
                if (this.isUnbound(j)) {
                    this.bindParameterName(j, (String)varNames.get(0));
                    break;
                }
                ++j;
            }
        }
    }

    private void maybeBindReferencePointcutParameter() {
        if (this.numberOfRemainingUnboundArguments > 1) {
            throw new AmbiguousBindingException("Still " + this.numberOfRemainingUnboundArguments + " unbound args at reference pointcut binding stage, with no way to determine between them");
        }
        ArrayList<String> varNames = new ArrayList<String>();
        String[] tokens = StringUtils.tokenizeToStringArray(this.pointcutExpression, " ");
        int i = 0;
        while (i < tokens.length) {
            block13: {
                String varName;
                String toMatch;
                block12: {
                    String nextToken;
                    block11: {
                        int firstParenIndex;
                        toMatch = tokens[i];
                        if (toMatch.startsWith("!")) {
                            toMatch = toMatch.substring(1);
                        }
                        if ((firstParenIndex = toMatch.indexOf("(")) == -1) break block11;
                        toMatch = toMatch.substring(0, firstParenIndex);
                        break block12;
                    }
                    if (tokens.length < i + 2 || (nextToken = tokens[i + 1]).charAt(0) != '(') break block13;
                }
                PointcutBody body = this.getPointcutBody(tokens, i);
                i += body.numTokensConsumed;
                if (!nonReferencePointcutTokens.contains(toMatch) && (varName = this.maybeExtractVariableName(body.text)) != null) {
                    varNames.add(varName);
                }
            }
            ++i;
        }
        if (varNames.size() > 1) {
            throw new AmbiguousBindingException("Found " + varNames.size() + " candidate reference pointcut variables but only one unbound argument slot");
        }
        if (varNames.size() == 1) {
            int j = 0;
            while (j < this.parameterNameBindings.length) {
                if (this.isUnbound(j)) {
                    this.bindParameterName(j, (String)varNames.get(0));
                    break;
                }
                ++j;
            }
        }
    }

    private PointcutBody getPointcutBody(String[] tokens, int startIndex) {
        int numTokensConsumed = 0;
        String currentToken = tokens[startIndex];
        int bodyStart = currentToken.indexOf(40);
        if (currentToken.charAt(currentToken.length() - 1) == ')') {
            return new PointcutBody(0, currentToken.substring(bodyStart + 1, currentToken.length() - 1));
        }
        StringBuilder sb = new StringBuilder();
        if (bodyStart >= 0 && bodyStart != currentToken.length() - 1) {
            sb.append(currentToken.substring(bodyStart + 1));
            sb.append(" ");
        }
        int currentIndex = startIndex + ++numTokensConsumed;
        while (currentIndex < tokens.length) {
            if (tokens[currentIndex].equals("(")) {
                ++currentIndex;
                continue;
            }
            if (tokens[currentIndex].endsWith(")")) {
                sb.append(tokens[currentIndex].substring(0, tokens[currentIndex].length() - 1));
                return new PointcutBody(numTokensConsumed, sb.toString().trim());
            }
            String toAppend = tokens[currentIndex];
            if (toAppend.startsWith("(")) {
                toAppend = toAppend.substring(1);
            }
            sb.append(toAppend);
            sb.append(" ");
            ++currentIndex;
            ++numTokensConsumed;
        }
        return new PointcutBody(numTokensConsumed, null);
    }

    private void maybeBindPrimitiveArgsFromPointcutExpression() {
        int numUnboundPrimitives = this.countNumberOfUnboundPrimitiveArguments();
        if (numUnboundPrimitives > 1) {
            throw new AmbiguousBindingException("Found '" + numUnboundPrimitives + "' unbound primitive arguments with no way to distinguish between them.");
        }
        if (numUnboundPrimitives == 1) {
            ArrayList<String> varNames = new ArrayList<String>();
            String[] tokens = StringUtils.tokenizeToStringArray(this.pointcutExpression, " ");
            int i = 0;
            while (i < tokens.length) {
                if (tokens[i].equals("args") || tokens[i].startsWith("args(")) {
                    PointcutBody body = this.getPointcutBody(tokens, i);
                    i += body.numTokensConsumed;
                    this.maybeExtractVariableNamesFromArgs(body.text, varNames);
                }
                ++i;
            }
            if (varNames.size() > 1) {
                throw new AmbiguousBindingException("Found " + varNames.size() + " candidate variable names but only one candidate binding slot when matching primitive args");
            }
            if (varNames.size() == 1) {
                i = 0;
                while (i < this.argumentTypes.length) {
                    if (this.isUnbound(i) && this.argumentTypes[i].isPrimitive()) {
                        this.bindParameterName(i, (String)varNames.get(0));
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private boolean isUnbound(int i) {
        return this.parameterNameBindings[i] == null;
    }

    private boolean alreadyBound(String varName) {
        int i = 0;
        while (i < this.parameterNameBindings.length) {
            if (!this.isUnbound(i) && varName.equals(this.parameterNameBindings[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isSubtypeOf(Class supertype, int argumentNumber) {
        return supertype.isAssignableFrom(this.argumentTypes[argumentNumber]);
    }

    private int countNumberOfUnboundAnnotationArguments() {
        int count = 0;
        int i = 0;
        while (i < this.argumentTypes.length) {
            if (this.isUnbound(i) && this.isSubtypeOf(Annotation.class, i)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private int countNumberOfUnboundPrimitiveArguments() {
        int count = 0;
        int i = 0;
        while (i < this.argumentTypes.length) {
            if (this.isUnbound(i) && this.argumentTypes[i].isPrimitive()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private void findAndBind(Class argumentType, String varName) {
        int i = 0;
        while (i < this.argumentTypes.length) {
            if (this.isUnbound(i) && this.isSubtypeOf(argumentType, i)) {
                this.bindParameterName(i, varName);
                return;
            }
            ++i;
        }
        throw new IllegalStateException("Expected to find an unbound argument of type '" + argumentType.getName() + "'");
    }

    public static class AmbiguousBindingException
    extends RuntimeException {
        public AmbiguousBindingException(String msg) {
            super(msg);
        }
    }

    private static class PointcutBody {
        private int numTokensConsumed;
        private String text;

        public PointcutBody(int tokens, String text) {
            this.numTokensConsumed = tokens;
            this.text = text;
        }
    }
}

