/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class Selection
extends SpelNodeImpl {
    public static final int ALL = 0;
    public static final int FIRST = 1;
    public static final int LAST = 2;
    private final int variant;
    private final boolean nullSafe;

    public Selection(boolean nullSafe, int variant, int pos, SpelNodeImpl expression) {
        super(pos, expression);
        this.nullSafe = nullSafe;
        this.variant = variant;
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypedValue op = state.getActiveContextObject();
        Object operand = op.getValue();
        SpelNodeImpl selectionCriteria = this.children[0];
        if (operand instanceof Map) {
            Map mapdata = (Map)operand;
            HashMap result = new HashMap();
            Object lastKey = null;
            for (Map.Entry entry : mapdata.entrySet()) {
                try {
                    TypedValue kvpair = new TypedValue(entry, TypeDescriptor.valueOf(Map.Entry.class));
                    state.pushActiveContextObject(kvpair);
                    Object o = selectionCriteria.getValueInternal(state).getValue();
                    if (o instanceof Boolean) {
                        if (!((Boolean)o).booleanValue()) continue;
                        if (this.variant == 1) {
                            result.put(entry.getKey(), entry.getValue());
                            TypedValue typedValue = new TypedValue(result);
                            return typedValue;
                        }
                        result.put(entry.getKey(), entry.getValue());
                        lastKey = entry.getKey();
                        continue;
                    }
                    throw new SpelEvaluationException(selectionCriteria.getStartPosition(), SpelMessage.RESULT_OF_SELECTION_CRITERIA_IS_NOT_BOOLEAN, new Object[0]);
                }
                finally {
                    state.popActiveContextObject();
                }
            }
            if ((this.variant == 1 || this.variant == 2) && result.size() == 0) {
                return new TypedValue(null, TypeDescriptor.NULL);
            }
            if (this.variant == 2) {
                HashMap resultMap = new HashMap();
                Object lastValue = result.get(lastKey);
                resultMap.put(lastKey, lastValue);
                return new TypedValue(resultMap, TypeDescriptor.valueOf(Map.class));
            }
            return new TypedValue(result, op.getTypeDescriptor());
        }
        if (operand instanceof Collection || ObjectUtils.isArray(operand)) {
            ArrayList data = new ArrayList();
            Collection c = operand instanceof Collection ? (Collection)operand : (Collection)Arrays.asList(ObjectUtils.toObjectArray(operand));
            data.addAll(c);
            ArrayList result = new ArrayList();
            int idx = 0;
            for (Object element : data) {
                try {
                    state.pushActiveContextObject(new TypedValue(element, op.getTypeDescriptor().getElementTypeDescriptor()));
                    state.enterScope("index", idx);
                    Object o = selectionCriteria.getValueInternal(state).getValue();
                    if (o instanceof Boolean) {
                        if (((Boolean)o).booleanValue()) {
                            if (this.variant == 1) {
                                TypedValue typedValue = new TypedValue(element, op.getTypeDescriptor().getElementTypeDescriptor());
                                return typedValue;
                            }
                            result.add(element);
                        }
                    } else {
                        throw new SpelEvaluationException(selectionCriteria.getStartPosition(), SpelMessage.RESULT_OF_SELECTION_CRITERIA_IS_NOT_BOOLEAN, new Object[0]);
                    }
                    ++idx;
                }
                finally {
                    state.exitScope();
                    state.popActiveContextObject();
                }
            }
            if ((this.variant == 1 || this.variant == 2) && result.size() == 0) {
                return TypedValue.NULL;
            }
            if (this.variant == 2) {
                return new TypedValue(result.get(result.size() - 1), op.getTypeDescriptor().getElementTypeDescriptor());
            }
            if (operand instanceof Collection) {
                return new TypedValue(result, op.getTypeDescriptor());
            }
            Class<?> elementType = ClassUtils.resolvePrimitiveIfNecessary(op.getTypeDescriptor().getElementType());
            Object resultArray = Array.newInstance(elementType, result.size());
            System.arraycopy(result.toArray(), 0, resultArray, 0, result.size());
            return new TypedValue(resultArray, op.getTypeDescriptor());
        }
        if (operand == null) {
            if (this.nullSafe) {
                return TypedValue.NULL;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INVALID_TYPE_FOR_SELECTION, "null");
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INVALID_TYPE_FOR_SELECTION, operand.getClass().getName());
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        switch (this.variant) {
            case 0: {
                sb.append("?[");
                break;
            }
            case 1: {
                sb.append("^[");
                break;
            }
            case 2: {
                sb.append("$[");
            }
        }
        return sb.append(this.getChild(0).toStringAST()).append("]").toString();
    }
}

