/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.api;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.TreeBasedTable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public class FetchResults {
    private final long[] m_timestamps;
    private final Map<String, double[]> m_columns;
    private final long m_step;
    private final Map<String, Object> m_constants;

    public FetchResults(long[] timestamps, Map<String, double[]> columns, long step, Map<String, Object> constants) {
        Preconditions.checkNotNull(timestamps, "timestamps argument");
        Preconditions.checkNotNull(columns, "columns argument");
        Preconditions.checkNotNull(constants, "constants argument");
        this.m_timestamps = timestamps;
        this.m_columns = columns;
        this.m_step = step;
        this.m_constants = constants;
    }

    public FetchResults(RowSortedTable<Integer, String, Double> values, long step, Map<String, Object> constants) {
        Preconditions.checkNotNull(values, "values argument");
        Preconditions.checkNotNull(constants, "constants argument");
        this.m_timestamps = this.transform(values);
        this.m_columns = new LinkedHashMap<String, double[]>();
        for (String column : values.columnKeySet()) {
            if ("timestamp".equals(column)) continue;
            this.m_columns.put(column, ArrayUtils.toPrimitive((Double[])values.column(column).values().toArray(new Double[0])));
        }
        this.m_step = step;
        this.m_constants = constants;
    }

    private long[] transform(RowSortedTable<Integer, String, Double> values) {
        Collection<Long> timestampCollection = Collections2.transform(values.column("timestamp").values(), new Function<Double, Long>(){

            @Override
            public Long apply(Double input) {
                return input.longValue();
            }
        });
        return ArrayUtils.toPrimitive((Long[])timestampCollection.toArray(new Long[0]));
    }

    public long[] getTimestamps() {
        return this.m_timestamps;
    }

    public Map<String, double[]> getColumns() {
        return this.m_columns;
    }

    public long getStep() {
        return this.m_step;
    }

    public Map<String, Object> getConstants() {
        return this.m_constants;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("timestamps", Arrays.toString(this.m_timestamps)).add("columns", this.m_columns).add("step", this.m_step).add("constants", this.m_constants).toString();
    }

    public RowSortedTable<Integer, String, Double> asRowSortedTable() {
        TreeBasedTable<Integer, String, Double> table = TreeBasedTable.create();
        for (int i = 0; i < this.m_timestamps.length; ++i) {
            table.put(i, "timestamp", Double.valueOf(this.m_timestamps[i]));
            for (String column : this.m_columns.keySet()) {
                table.put(i, column, this.m_columns.get(column)[i]);
            }
        }
        return table;
    }
}

