/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.measurement;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.opennms.netmgt.jasper.measurement.EmptyJRDataSource;
import org.opennms.netmgt.jasper.measurement.MeasurementApiConnector;
import org.opennms.netmgt.jasper.measurement.MeasurementDataSource;
import org.opennms.netmgt.jasper.measurement.MeasurementQueryExecutor;
import org.opennms.netmgt.jasper.measurement.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteMeasurementDataSourceWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(MeasurementQueryExecutor.class);
    private final MeasurementApiConnector connector = new MeasurementApiConnector();
    private final String url;
    private final String username;
    private final String password;
    private final boolean useSsl;

    public RemoteMeasurementDataSourceWrapper(boolean useSsl, String url, String username, String password) {
        this.username = username;
        this.password = password;
        this.url = url;
        this.useSsl = useSsl;
    }

    public JRRewindableDataSource createDataSource(String query) throws JRException {
        try {
            Result result = this.connector.execute(this.useSsl, this.url, this.username, this.password, query);
            if (result.wasRedirection()) {
                throw new IOException("Request was redirected. This is not supported.");
            }
            if (404 == result.getResponseCode()) {
                LOG.warn("Got a 404 (Not Found) response. This might be due to a wrong url or the resource does not exist. Requested URL was: '{}'", (Object)this.url);
                return new EmptyJRDataSource();
            }
            if (result.wasSuccessful() && result.getInputStream() != null) {
                return new MeasurementDataSource(result.getInputStream());
            }
            ByteArrayOutputStream errorMessageStream = new ByteArrayOutputStream();
            if (result.getErrorStream() != null) {
                ByteStreams.copy(result.getErrorStream(), (OutputStream)errorMessageStream);
            }
            throw new JRException("Invalid request. Response was : " + result.getResponseCode() + " (" + result.getResponseMessage() + ")\n" + errorMessageStream.toString());
        }
        catch (IOException ioException) {
            throw new JRException((Throwable)ioException);
        }
    }

    public void disconnect() {
        if (this.connector != null) {
            this.connector.disconnect();
        }
    }
}

