/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.importer.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.OnmsDao;
import org.opennms.netmgt.importer.operations.DefaultImportStatistics;
import org.opennms.netmgt.importer.operations.ImportOperation;
import org.opennms.netmgt.importer.operations.ImportOperationFactory;
import org.opennms.netmgt.importer.operations.ImportStatistics;
import org.opennms.netmgt.importer.operations.InsertOperation;
import org.opennms.netmgt.importer.operations.SaveOrUpdateOperation;
import org.opennms.netmgt.importer.operations.UpdateOperation;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class ImportOperationsManager {
    private List<ImportOperation> m_inserts = new LinkedList<ImportOperation>();
    private List<ImportOperation> m_updates = new LinkedList<ImportOperation>();
    private Map<String, Integer> m_foreignIdToNodeMap;
    private ImportOperationFactory m_operationFactory;
    private ImportStatistics m_stats = new DefaultImportStatistics();
    private EventIpcManager m_eventMgr;
    private int m_scanThreads = 50;
    private int m_writeThreads = 4;
    private String m_foreignSource;

    public ImportOperationsManager(Map<String, Integer> foreignIdToNodeMap, ImportOperationFactory operationFactory) {
        this.m_foreignIdToNodeMap = new HashMap<String, Integer>(foreignIdToNodeMap);
        this.m_operationFactory = operationFactory;
    }

    public SaveOrUpdateOperation foundNode(String foreignId, String nodeLabel, String building, String city) {
        if (this.nodeExists(foreignId)) {
            return this.updateNode(foreignId, nodeLabel, building, city);
        }
        return this.insertNode(foreignId, nodeLabel, building, city);
    }

    private boolean nodeExists(String foreignId) {
        return this.m_foreignIdToNodeMap.containsKey(foreignId);
    }

    private SaveOrUpdateOperation insertNode(String foreignId, String nodeLabel, String building, String city) {
        InsertOperation insertOperation = this.m_operationFactory.createInsertOperation(this.getForeignSource(), foreignId, nodeLabel, building, city);
        this.m_inserts.add(insertOperation);
        return insertOperation;
    }

    private SaveOrUpdateOperation updateNode(String foreignId, String nodeLabel, String building, String city) {
        Integer nodeId = this.processForeignId(foreignId);
        UpdateOperation updateOperation = this.m_operationFactory.createUpdateOperation(nodeId, this.getForeignSource(), foreignId, nodeLabel, building, city);
        this.m_updates.add(updateOperation);
        return updateOperation;
    }

    private Integer processForeignId(String foreignId) {
        return this.m_foreignIdToNodeMap.remove(foreignId);
    }

    public int getOperationCount() {
        return this.m_inserts.size() + this.m_updates.size() + this.m_foreignIdToNodeMap.size();
    }

    public int getInsertCount() {
        return this.m_inserts.size();
    }

    public int getUpdateCount() {
        return this.m_updates.size();
    }

    public int getDeleteCount() {
        return this.m_foreignIdToNodeMap.size();
    }

    public void shutdownAndWaitForCompletion(ExecutorService executorService, String msg) {
        executorService.shutdown();
        try {
            while (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException e) {
            this.log().error(msg, (Throwable)e);
        }
    }

    public void persistOperations(TransactionTemplate template, OnmsDao<?, ?> dao) {
        this.m_stats.beginProcessingOps();
        this.m_stats.setDeleteCount(this.getDeleteCount());
        this.m_stats.setInsertCount(this.getInsertCount());
        this.m_stats.setUpdateCount(this.getUpdateCount());
        ExecutorService pool = Executors.newFixedThreadPool(this.m_writeThreads, (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName() + ".persistOperations", this.m_writeThreads, false));
        this.preprocessOperations(template, dao, new OperationIterator(), pool);
        this.shutdownAndWaitForCompletion(pool, "persister interrupted!");
        this.m_stats.finishProcessingOps();
    }

    private void preprocessOperations(final TransactionTemplate template, final OnmsDao<?, ?> dao, OperationIterator iterator, final ExecutorService dbPool) {
        this.m_stats.beginPreprocessingOps();
        ExecutorService pool = Executors.newFixedThreadPool(this.m_scanThreads, (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName() + ".preprocessOperations", this.m_scanThreads, false));
        OperationIterator it = iterator;
        while (it.hasNext()) {
            final ImportOperation oper = (ImportOperation)it.next();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ImportOperationsManager.this.preprocessOperation(oper, template, dao, dbPool);
                }
            };
            pool.execute(r);
        }
        this.shutdownAndWaitForCompletion(pool, "preprocessor interrupted!");
        this.m_stats.finishPreprocessingOps();
    }

    protected void preprocessOperation(final ImportOperation oper, final TransactionTemplate template, final OnmsDao<?, ?> dao, ExecutorService dbPool) {
        this.m_stats.beginPreprocessing(oper);
        this.log().info("Preprocess: " + oper);
        oper.gatherAdditionalData();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ImportOperationsManager.this.persistOperation(oper, template, dao);
            }
        };
        dbPool.execute(r);
        this.m_stats.finishPreprocessing(oper);
    }

    protected void persistOperation(ImportOperation oper, TransactionTemplate template, OnmsDao<?, ?> dao) {
        this.m_stats.beginPersisting(oper);
        this.log().info("Persist: " + oper);
        List<Event> events = this.persistToDatabase(oper, template);
        this.m_stats.finishPersisting(oper);
        if (this.m_eventMgr != null && events != null) {
            this.m_stats.beginSendingEvents(oper, events);
            this.log().info("Send Events: " + oper);
            for (Event event : events) {
                this.m_eventMgr.sendNow(event);
            }
            this.m_stats.finishSendingEvents(oper, events);
        }
        this.log().info("Clear cache: " + oper);
        dao.clear();
    }

    private List<Event> persistToDatabase(final ImportOperation oper, TransactionTemplate template) {
        List events = (List)template.execute((TransactionCallback)new TransactionCallback<List<Event>>(){

            public List<Event> doInTransaction(TransactionStatus status) {
                List<Event> result = oper.persist();
                return result;
            }
        });
        return events;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void setScanThreads(int scanThreads) {
        this.m_scanThreads = scanThreads;
    }

    public void setWriteThreads(int writeThreads) {
        this.m_writeThreads = writeThreads;
    }

    public EventIpcManager getEventMgr() {
        return this.m_eventMgr;
    }

    public void setEventMgr(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public ImportStatistics getStats() {
        return this.m_stats;
    }

    public void setStats(ImportStatistics stats) {
        this.m_stats = stats;
    }

    public void setForeignSource(String foreignSource) {
        this.m_foreignSource = foreignSource;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    class OperationIterator
    implements Iterator<ImportOperation> {
        Iterator<Iterator<ImportOperation>> m_iterIter;
        Iterator<ImportOperation> m_currentIter;

        OperationIterator() {
            ArrayList iters = new ArrayList(3);
            iters.add(new DeleteIterator());
            iters.add(ImportOperationsManager.this.m_updates.iterator());
            iters.add(ImportOperationsManager.this.m_inserts.iterator());
            this.m_iterIter = iters.iterator();
        }

        @Override
        public boolean hasNext() {
            while ((this.m_currentIter == null || !this.m_currentIter.hasNext()) && this.m_iterIter.hasNext()) {
                this.m_currentIter = this.m_iterIter.next();
                this.m_iterIter.remove();
            }
            return this.m_currentIter == null ? false : this.m_currentIter.hasNext();
        }

        @Override
        public ImportOperation next() {
            return this.m_currentIter.next();
        }

        @Override
        public void remove() {
            this.m_currentIter.remove();
        }
    }

    class DeleteIterator
    implements Iterator<ImportOperation> {
        private Iterator<Map.Entry<String, Integer>> m_foreignIdIterator;

        DeleteIterator() {
            this.m_foreignIdIterator = ImportOperationsManager.this.m_foreignIdToNodeMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.m_foreignIdIterator.hasNext();
        }

        @Override
        public ImportOperation next() {
            Map.Entry<String, Integer> entry = this.m_foreignIdIterator.next();
            Integer nodeId = entry.getValue();
            String foreignId = entry.getKey();
            return ImportOperationsManager.this.m_operationFactory.createDeleteOperation(nodeId, ImportOperationsManager.this.m_foreignSource, foreignId);
        }

        @Override
        public void remove() {
            this.m_foreignIdIterator.remove();
        }
    }
}

