/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.importer.config;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.importer.config.Node;
import org.xml.sax.ContentHandler;

public class ModelImport
implements Serializable {
    private Date _dateStamp;
    private Date _lastImport;
    private String _foreignSource = "imported:";
    private List<Node> _nodeList;

    public ModelImport() {
        this.setForeignSource("imported:");
        this._nodeList = new ArrayList<Node>();
    }

    public void addNode(Node vNode) throws IndexOutOfBoundsException {
        this._nodeList.add(vNode);
    }

    public void addNode(int index, Node vNode) throws IndexOutOfBoundsException {
        this._nodeList.add(index, vNode);
    }

    public Enumeration<Node> enumerateNode() {
        return Collections.enumeration(this._nodeList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ModelImport) {
            ModelImport temp = (ModelImport)obj;
            if (this._dateStamp != null) {
                if (temp._dateStamp == null) {
                    return false;
                }
                if (!this._dateStamp.equals(temp._dateStamp)) {
                    return false;
                }
            } else if (temp._dateStamp != null) {
                return false;
            }
            if (this._lastImport != null) {
                if (temp._lastImport == null) {
                    return false;
                }
                if (!this._lastImport.equals(temp._lastImport)) {
                    return false;
                }
            } else if (temp._lastImport != null) {
                return false;
            }
            if (this._foreignSource != null) {
                if (temp._foreignSource == null) {
                    return false;
                }
                if (!this._foreignSource.equals(temp._foreignSource)) {
                    return false;
                }
            } else if (temp._foreignSource != null) {
                return false;
            }
            if (this._nodeList != null) {
                if (temp._nodeList == null) {
                    return false;
                }
                if (!this._nodeList.equals(temp._nodeList)) {
                    return false;
                }
            } else if (temp._nodeList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Date getDateStamp() {
        return this._dateStamp;
    }

    public String getForeignSource() {
        return this._foreignSource;
    }

    public Date getLastImport() {
        return this._lastImport;
    }

    public Node getNode(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._nodeList.size()) {
            throw new IndexOutOfBoundsException("getNode: Index value '" + index + "' not in range [0.." + (this._nodeList.size() - 1) + "]");
        }
        return this._nodeList.get(index);
    }

    public Node[] getNode() {
        Node[] array = new Node[]{};
        return this._nodeList.toArray(array);
    }

    public List<Node> getNodeCollection() {
        return this._nodeList;
    }

    public int getNodeCount() {
        return this._nodeList.size();
    }

    public int hashCode() {
        int result = 17;
        if (this._dateStamp != null) {
            result = 37 * result + this._dateStamp.hashCode();
        }
        if (this._lastImport != null) {
            result = 37 * result + this._lastImport.hashCode();
        }
        if (this._foreignSource != null) {
            result = 37 * result + this._foreignSource.hashCode();
        }
        if (this._nodeList != null) {
            result = 37 * result + this._nodeList.hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Node> iterateNode() {
        return this._nodeList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllNode() {
        this._nodeList.clear();
    }

    public boolean removeNode(Node vNode) {
        boolean removed = this._nodeList.remove(vNode);
        return removed;
    }

    public Node removeNodeAt(int index) {
        Node obj = this._nodeList.remove(index);
        return obj;
    }

    public void setDateStamp(Date dateStamp) {
        this._dateStamp = dateStamp;
    }

    public void setForeignSource(String foreignSource) {
        this._foreignSource = foreignSource;
    }

    public void setLastImport(Date lastImport) {
        this._lastImport = lastImport;
    }

    public void setNode(int index, Node vNode) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._nodeList.size()) {
            throw new IndexOutOfBoundsException("setNode: Index value '" + index + "' not in range [0.." + (this._nodeList.size() - 1) + "]");
        }
        this._nodeList.set(index, vNode);
    }

    public void setNode(Node[] vNodeArray) {
        this._nodeList.clear();
        for (int i = 0; i < vNodeArray.length; ++i) {
            this._nodeList.add(vNodeArray[i]);
        }
    }

    public void setNode(List<Node> vNodeList) {
        this._nodeList.clear();
        this._nodeList.addAll(vNodeList);
    }

    public void setNodeCollection(List<Node> nodeList) {
        this._nodeList = nodeList;
    }

    public static ModelImport unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (ModelImport)Unmarshaller.unmarshal(ModelImport.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

