/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.importer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.importer.BaseImporter;
import org.opennms.netmgt.importer.ModelImportException;
import org.opennms.netmgt.importer.operations.AbstractSaveOrUpdateOperation;
import org.opennms.netmgt.importer.operations.ImportOperation;
import org.opennms.netmgt.importer.operations.ImportOperationsManager;
import org.opennms.netmgt.importer.operations.ImportStatistics;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class ImporterService
extends BaseImporter
implements SpringServiceDaemon,
DisposableBean,
EventListener {
    public static final String NAME = "ModelImporter";
    private volatile Resource m_importResource;
    private volatile EventIpcManager m_eventManager;
    private volatile ImporterStats m_stats;

    public void doImport() {
        this.doImport(null);
    }

    private void doImport(Event event) {
        Resource resource = null;
        try {
            this.m_stats = new ImporterStats();
            resource = event != null && this.getEventUrl(event) != null ? new UrlResource(this.getEventUrl(event)) : this.m_importResource;
            this.sendImportStarted(resource);
            this.importModelFromResource(resource, this.m_stats, event);
            this.log().info("Finished Importing: " + this.m_stats);
            this.sendImportSuccessful(this.m_stats, resource);
        }
        catch (IOException e) {
            String msg = "IOException importing " + resource;
            this.log().error(msg, (Throwable)e);
            this.sendImportFailed(msg + ": " + e.getMessage(), resource);
        }
        catch (ModelImportException e) {
            String msg = "Error parsing import data from " + resource;
            this.log().error(msg, (Throwable)e);
            this.sendImportFailed(msg + ": " + e.getMessage(), resource);
        }
    }

    private String getEventUrl(Event event) {
        return EventUtils.getParm((Event)event, (String)"url");
    }

    public String getStats() {
        return this.m_stats == null ? "No Stats Availabile" : this.m_stats.toString();
    }

    private void sendImportSuccessful(ImporterStats stats, Resource resource) {
        EventBuilder builder = new EventBuilder("uei.opennms.org/internal/importer/importSuccessful", NAME);
        builder.addParam("importResource", resource.toString());
        builder.addParam("importStats", stats.toString());
        this.m_eventManager.sendNow(builder.getEvent());
    }

    private void sendImportFailed(String msg, Resource resource) {
        EventBuilder builder = new EventBuilder("uei.opennms.org/internal/importer/importFailed", NAME);
        builder.addParam("importResource", resource.toString());
        builder.addParam("failureMessage", msg);
        this.m_eventManager.sendNow(builder.getEvent());
    }

    private void sendImportStarted(Resource resource) {
        EventBuilder builder = new EventBuilder("uei.opennms.org/internal/importer/importStarted", NAME);
        builder.addParam("importResource", resource.toString());
        this.m_eventManager.sendNow(builder.getEvent());
    }

    public void setImportResource(Resource resource) {
        this.m_importResource = resource;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventManager;
    }

    public void setEventManager(EventIpcManager eventManager) {
        this.m_eventManager = eventManager;
    }

    @Override
    protected ImportOperationsManager createImportOperationsManager(Map<String, Integer> assetNumbersToNodes, ImportStatistics stats) {
        ImportOperationsManager opsMgr = super.createImportOperationsManager(assetNumbersToNodes, stats);
        opsMgr.setEventMgr(this.m_eventManager);
        return opsMgr;
    }

    public void afterPropertiesSet() throws Exception {
        this.m_eventManager.addEventListener((EventListener)this, "uei.opennms.org/internal/importer/reloadImport");
    }

    public void destroy() throws Exception {
        this.m_eventManager.removeEventListener((EventListener)this, "uei.opennms.org/internal/importer/reloadImport");
    }

    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event e) {
        String oldPrefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)NAME);
            if (!"uei.opennms.org/internal/importer/reloadImport".equals(e.getUei())) {
                return;
            }
            this.doImport(e);
        }
        finally {
            ThreadCategory.setPrefix((String)oldPrefix);
        }
    }

    public void start() throws Exception {
    }

    public class WorkEffort {
        private String m_name;
        private long m_totalTime;
        private long m_sectionCount;
        private ThreadLocal<Duration> m_pendingSection = new ThreadLocal();

        public WorkEffort(String name) {
            this.m_name = name;
        }

        public void begin() {
            Duration pending = new Duration();
            pending.start();
            this.m_pendingSection.set(pending);
        }

        public void end() {
            Duration pending = this.m_pendingSection.get();
            ++this.m_sectionCount;
            this.m_totalTime += pending.getLength();
        }

        public long getTotalTime() {
            return this.m_totalTime;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Total ").append(this.m_name).append(": ");
            buf.append((double)this.m_totalTime / 1000.0).append(" thread-seconds ");
            if (this.m_sectionCount > 0L) {
                buf.append("Avg ").append(this.m_name).append(": ");
                buf.append((double)this.m_totalTime / (double)this.m_sectionCount).append(" ms per node");
            }
            return buf.toString();
        }
    }

    public class Duration {
        private String m_name = null;
        private long m_start = -1L;
        private long m_end = -1L;

        public Duration() {
            this(null);
        }

        public Duration(String name) {
            this.m_name = name;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public void start() {
            this.m_start = System.currentTimeMillis();
        }

        public void end() {
            this.m_end = System.currentTimeMillis();
        }

        public long getLength() {
            if (this.m_start == -1L) {
                return 0L;
            }
            long end = this.m_end == -1L ? System.currentTimeMillis() : this.m_end;
            return end - this.m_start;
        }

        public String toString() {
            return (this.m_name == null ? "" : this.m_name + ": ") + (this.m_start == -1L ? "has not begun" : this.elapsedTime());
        }

        private String elapsedTime() {
            long duration = this.getLength();
            long hours = duration / 3600000L;
            long mins = (duration %= 3600000L) / 60000L;
            long secs = (duration %= 60000L) / 1000L;
            long millis = duration % 1000L;
            StringBuffer elapsed = new StringBuffer();
            if (hours > 0L) {
                elapsed.append(hours).append("h ");
            }
            if (mins > 0L) {
                elapsed.append(mins).append("m ");
            }
            if (secs > 0L) {
                elapsed.append(secs).append("s ");
            }
            if (millis > 0L) {
                elapsed.append(millis).append("ms");
            }
            return elapsed.toString();
        }
    }

    public class ImporterStats
    implements ImportStatistics {
        private Duration m_importDuration;
        private Duration m_auditDuration;
        private Duration m_loadingDuration;
        private Duration m_processingDuration;
        private Duration m_preprocessingDuration;
        private Duration m_relateDuration;
        private WorkEffort m_preprocessingEffort;
        private WorkEffort m_processingEffort;
        private WorkEffort m_eventEffort;
        private int m_deleteCount;
        private int m_insertCount;
        private int m_updateCount;
        private int m_eventCount;

        public ImporterStats() {
            this.m_importDuration = new Duration("Importing");
            this.m_auditDuration = new Duration("Auditing");
            this.m_loadingDuration = new Duration("Loading");
            this.m_processingDuration = new Duration("Processing");
            this.m_preprocessingDuration = new Duration("Scanning");
            this.m_relateDuration = new Duration("Relating");
            this.m_preprocessingEffort = new WorkEffort("Scan Effort");
            this.m_processingEffort = new WorkEffort("Write Effort");
            this.m_eventEffort = new WorkEffort("Event Sending Effort");
        }

        @Override
        public void beginProcessingOps() {
            this.m_processingDuration.start();
        }

        @Override
        public void finishProcessingOps() {
            this.m_processingDuration.end();
        }

        @Override
        public void beginPreprocessingOps() {
            this.m_preprocessingDuration.start();
        }

        @Override
        public void finishPreprocessingOps() {
            this.m_preprocessingDuration.end();
        }

        @Override
        public void beginPreprocessing(ImportOperation oper) {
            if (oper instanceof AbstractSaveOrUpdateOperation) {
                this.m_preprocessingEffort.begin();
            }
        }

        @Override
        public void finishPreprocessing(ImportOperation oper) {
            if (oper instanceof AbstractSaveOrUpdateOperation) {
                this.m_preprocessingEffort.end();
            }
        }

        @Override
        public void beginPersisting(ImportOperation oper) {
            this.m_processingEffort.begin();
        }

        @Override
        public void finishPersisting(ImportOperation oper) {
            this.m_processingEffort.end();
        }

        @Override
        public void beginSendingEvents(ImportOperation oper, List<Event> events) {
            if (events != null) {
                this.m_eventCount += events.size();
            }
            this.m_eventEffort.begin();
        }

        @Override
        public void finishSendingEvents(ImportOperation oper, List<Event> events) {
            this.m_eventEffort.end();
        }

        @Override
        public void beginLoadingResource(Resource resource) {
            this.m_loadingDuration.setName("Loading Resource: " + resource);
            this.m_loadingDuration.start();
        }

        @Override
        public void finishLoadingResource(Resource resource) {
            this.m_loadingDuration.end();
        }

        @Override
        public void beginImporting() {
            this.m_importDuration.start();
        }

        @Override
        public void finishImporting() {
            this.m_importDuration.end();
        }

        @Override
        public void beginAuditNodes() {
            this.m_auditDuration.start();
        }

        @Override
        public void finishAuditNodes() {
            this.m_auditDuration.end();
        }

        @Override
        public void setDeleteCount(int deleteCount) {
            this.m_deleteCount = deleteCount;
        }

        @Override
        public void setInsertCount(int insertCount) {
            this.m_insertCount = insertCount;
        }

        @Override
        public void setUpdateCount(int updateCount) {
            this.m_updateCount = updateCount;
        }

        @Override
        public void beginRelateNodes() {
            this.m_relateDuration.start();
        }

        @Override
        public void finishRelateNodes() {
            this.m_relateDuration.end();
        }

        public String toString() {
            StringBuffer stats = new StringBuffer();
            stats.append("Deletes: ").append(this.m_deleteCount).append(' ');
            stats.append("Updates: ").append(this.m_updateCount).append(' ');
            stats.append("Inserts: ").append(this.m_insertCount).append('\n');
            stats.append(this.m_importDuration).append(' ');
            stats.append(this.m_loadingDuration).append(' ');
            stats.append(this.m_auditDuration).append('\n');
            stats.append(this.m_preprocessingDuration).append(' ');
            stats.append(this.m_processingDuration).append(' ');
            stats.append(this.m_relateDuration).append(' ');
            stats.append(this.m_preprocessingEffort).append(' ');
            stats.append(this.m_processingEffort).append(' ');
            stats.append(this.m_eventEffort).append(' ');
            if (this.m_eventCount > 0) {
                stats.append("Avg ").append((double)this.m_eventEffort.getTotalTime() / (double)this.m_eventCount).append(" ms per event");
            }
            return stats.toString();
        }
    }
}

