/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.importer;

import org.opennms.netmgt.importer.config.Asset;
import org.opennms.netmgt.importer.config.Category;
import org.opennms.netmgt.importer.config.Interface;
import org.opennms.netmgt.importer.config.MonitoredService;
import org.opennms.netmgt.importer.config.Node;
import org.opennms.netmgt.importer.operations.ImportOperationsManager;
import org.opennms.netmgt.importer.operations.SaveOrUpdateOperation;
import org.opennms.netmgt.importer.specification.AbstractImportVisitor;

public class ImportAccountant
extends AbstractImportVisitor {
    private final ImportOperationsManager m_opsMgr;
    private SaveOrUpdateOperation m_currentOp;

    public ImportAccountant(ImportOperationsManager opsMgr) {
        this.m_opsMgr = opsMgr;
    }

    @Override
    public void visitNode(Node node) {
        this.m_currentOp = this.m_opsMgr.foundNode(node.getForeignId(), node.getNodeLabel(), node.getBuilding(), node.getCity());
    }

    @Override
    public void completeNode(Node node) {
        this.m_currentOp = null;
    }

    @Override
    public void visitInterface(Interface iface) {
        this.m_currentOp.foundInterface(iface.getIpAddr(), iface.getDescr(), iface.getSnmpPrimary(), iface.getManaged(), iface.getStatus());
    }

    @Override
    public void visitMonitoredService(MonitoredService svc) {
        this.m_currentOp.foundMonitoredService(svc.getServiceName());
    }

    @Override
    public void visitCategory(Category category) {
        this.m_currentOp.foundCategory(category.getName());
    }

    @Override
    public void visitAsset(Asset asset) {
        this.m_currentOp.foundAsset(asset.getName(), asset.getValue());
    }
}

