/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.importer;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.AssetRecordDao;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.DistPollerDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.OnmsDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.importer.ImportAccountant;
import org.opennms.netmgt.importer.ModelImportException;
import org.opennms.netmgt.importer.config.Node;
import org.opennms.netmgt.importer.operations.DefaultImportStatistics;
import org.opennms.netmgt.importer.operations.DeleteOperation;
import org.opennms.netmgt.importer.operations.ImportOperationFactory;
import org.opennms.netmgt.importer.operations.ImportOperationsManager;
import org.opennms.netmgt.importer.operations.ImportStatistics;
import org.opennms.netmgt.importer.operations.InsertOperation;
import org.opennms.netmgt.importer.operations.UpdateOperation;
import org.opennms.netmgt.importer.specification.AbstractImportVisitor;
import org.opennms.netmgt.importer.specification.SpecFile;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.PathElement;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.core.io.Resource;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class BaseImporter
implements ImportOperationFactory {
    protected TransactionTemplate m_transTemplate;
    protected DistPollerDao m_distPollerDao;
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private ServiceTypeDao m_serviceTypeDao;
    private MonitoredServiceDao m_monitoredServiceDao;
    private AssetRecordDao m_assetRecordDao;
    private CategoryDao m_categoryDao;
    private final ThreadLocal<HashMap<String, OnmsServiceType>> m_typeCache = new ThreadLocal();
    private final ThreadLocal<HashMap<String, OnmsCategory>> m_categoryCache = new ThreadLocal();
    private int m_scanThreads = 50;
    private int m_writeThreads = 4;

    public void setTransactionTemplate(TransactionTemplate transTemplate) {
        this.m_transTemplate = transTemplate;
    }

    public DistPollerDao getDistPollerDao() {
        return this.m_distPollerDao;
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.m_distPollerDao = distPollerDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public MonitoredServiceDao getMonitoredServiceDao() {
        return this.m_monitoredServiceDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monitoredServiceDao) {
        this.m_monitoredServiceDao = monitoredServiceDao;
    }

    public ServiceTypeDao getServiceTypeDao() {
        return this.m_serviceTypeDao;
    }

    public void setServiceTypeDao(ServiceTypeDao serviceTypeDao) {
        this.m_serviceTypeDao = serviceTypeDao;
    }

    public AssetRecordDao getAssetRecordDao() {
        return this.m_assetRecordDao;
    }

    public void setAssetRecordDao(AssetRecordDao assetRecordDao) {
        this.m_assetRecordDao = assetRecordDao;
    }

    public TransactionTemplate getTransTemplate() {
        return this.m_transTemplate;
    }

    public void setTransTemplate(TransactionTemplate transTemplate) {
        this.m_transTemplate = transTemplate;
    }

    @Override
    public InsertOperation createInsertOperation(String foreignSource, String foreignId, String nodeLabel, String building, String city) {
        InsertOperation insertOperation = new InsertOperation(foreignSource, foreignId, nodeLabel, building, city);
        insertOperation.setNodeDao(this.m_nodeDao);
        insertOperation.setDistPollerDao(this.m_distPollerDao);
        insertOperation.setServiceTypeDao(this.m_serviceTypeDao);
        insertOperation.setCategoryDao(this.m_categoryDao);
        insertOperation.setTypeCache(this.m_typeCache);
        insertOperation.setCategoryCache(this.m_categoryCache);
        return insertOperation;
    }

    @Override
    public UpdateOperation createUpdateOperation(Integer nodeId, String foreignSource, String foreignId, String nodeLabel, String building, String city) {
        UpdateOperation updateOperation = new UpdateOperation(nodeId, foreignSource, foreignId, nodeLabel, building, city);
        updateOperation.setNodeDao(this.m_nodeDao);
        updateOperation.setDistPollerDao(this.m_distPollerDao);
        updateOperation.setServiceTypeDao(this.m_serviceTypeDao);
        updateOperation.setCategoryDao(this.m_categoryDao);
        updateOperation.setTypeCache(this.m_typeCache);
        updateOperation.setCategoryCache(this.m_categoryCache);
        return updateOperation;
    }

    @Override
    public DeleteOperation createDeleteOperation(Integer nodeId, String foreignSource, String foreignId) {
        return new DeleteOperation(nodeId, foreignSource, foreignId, this.m_nodeDao);
    }

    protected void importModelFromResource(Resource resource) throws IOException, ModelImportException {
        this.importModelFromResource(resource, new DefaultImportStatistics(), null);
    }

    protected void importModelFromResource(Resource resource, ImportStatistics stats, Event event) throws IOException, ModelImportException {
        stats.beginImporting();
        stats.beginLoadingResource(resource);
        SpecFile specFile = new SpecFile();
        specFile.loadResource(resource);
        stats.finishLoadingResource(resource);
        if (event != null && this.getEventForeignSource(event) != null) {
            specFile.setForeignSource(this.getEventForeignSource(event));
        }
        stats.beginAuditNodes();
        this.createDistPollerIfNecessary();
        Map<String, Integer> foreignIdsToNodes = this.getForeignIdToNodeMap(specFile.getForeignSource());
        ImportOperationsManager opsMgr = this.createImportOperationsManager(foreignIdsToNodes, stats);
        opsMgr.setForeignSource(specFile.getForeignSource());
        opsMgr.setScanThreads(this.m_scanThreads);
        opsMgr.setWriteThreads(this.m_writeThreads);
        this.auditNodes(opsMgr, specFile);
        stats.finishAuditNodes();
        opsMgr.persistOperations(this.m_transTemplate, (OnmsDao<?, ?>)this.getNodeDao());
        stats.beginRelateNodes();
        this.relateNodes(specFile);
        stats.finishRelateNodes();
        stats.finishImporting();
    }

    private String getEventForeignSource(Event event) {
        return EventUtil.getNamedParmValue((String)"parm[foreignSource]", (Event)event);
    }

    protected ImportOperationsManager createImportOperationsManager(Map<String, Integer> foreignIdsToNodes, ImportStatistics stats) {
        ImportOperationsManager opsMgr = new ImportOperationsManager(foreignIdsToNodes, this);
        opsMgr.setStats(stats);
        return opsMgr;
    }

    private void auditNodes(final ImportOperationsManager opsMgr, final SpecFile specFile) {
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                ImportAccountant accountant = new ImportAccountant(opsMgr);
                specFile.visitImport(accountant);
                return null;
            }
        });
    }

    private void relateNodes(SpecFile specFile) {
        specFile.visitImport(new NodeRelator(specFile.getForeignSource()));
    }

    public ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private Map<String, Integer> getForeignIdToNodeMap(final String foreignSource) {
        return (Map)this.m_transTemplate.execute((TransactionCallback)new TransactionCallback<Map<String, Integer>>(){

            public Map<String, Integer> doInTransaction(TransactionStatus status) {
                return BaseImporter.this.getNodeDao().getForeignIdToNodeIdMap(foreignSource);
            }
        });
    }

    private OnmsDistPoller createDistPollerIfNecessary() {
        return (OnmsDistPoller)this.m_transTemplate.execute((TransactionCallback)new TransactionCallback<OnmsDistPoller>(){

            public OnmsDistPoller doInTransaction(TransactionStatus status) {
                OnmsDistPoller distPoller = (OnmsDistPoller)BaseImporter.this.m_distPollerDao.get((Serializable)((Object)"localhost"));
                if (distPoller == null) {
                    distPoller = new OnmsDistPoller("localhost", "127.0.0.1");
                    BaseImporter.this.m_distPollerDao.save((Object)distPoller);
                }
                return distPoller;
            }
        });
    }

    public CategoryDao getCategoryDao() {
        return this.m_categoryDao;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.m_categoryDao = categoryDao;
    }

    public int getScanThreads() {
        return this.m_scanThreads;
    }

    public void setScanThreads(int poolSize) {
        this.m_scanThreads = poolSize;
    }

    public int getWriteThreads() {
        return this.m_writeThreads;
    }

    public void setWriteThreads(int writeThreads) {
        this.m_writeThreads = writeThreads;
    }

    class NodeRelator
    extends AbstractImportVisitor {
        String m_foreignSource;

        public NodeRelator(String foreignSource) {
            this.m_foreignSource = foreignSource;
        }

        @Override
        public void visitNode(final Node node) {
            BaseImporter.this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    OnmsNode dbNode = NodeRelator.this.findNodeByForeignId(NodeRelator.this.m_foreignSource, node.getForeignId());
                    if (dbNode == null) {
                        BaseImporter.this.log().error("Error setting parent on node: " + node.getForeignId() + " node not in database");
                        return;
                    }
                    OnmsNode parent = NodeRelator.this.findParent(node);
                    OnmsIpInterface critIface = null;
                    if (parent != null) {
                        critIface = this.getCriticalInterface(parent);
                    }
                    BaseImporter.this.log().info("Setting parent of node: " + dbNode + " to: " + parent);
                    dbNode.setParent(parent);
                    BaseImporter.this.log().info("Setting criticalInterface of node: " + dbNode + " to: " + critIface);
                    if (critIface == null) {
                        dbNode.setPathElement(null);
                    } else {
                        String ipAddress = InetAddressUtils.str((InetAddress)critIface.getIpAddress());
                        dbNode.setPathElement(new PathElement(ipAddress, "ICMP"));
                    }
                    BaseImporter.this.getNodeDao().update((Object)dbNode);
                }

                private OnmsIpInterface getCriticalInterface(OnmsNode parent) {
                    OnmsIpInterface critIface = parent.getPrimaryInterface();
                    if (critIface != null) {
                        return critIface;
                    }
                    return parent.getInterfaceWithService("ICMP");
                }
            });
        }

        private OnmsNode findParent(Node node) {
            if (node.getParentForeignId() != null) {
                return this.findNodeByForeignId(this.m_foreignSource, node.getParentForeignId());
            }
            if (node.getParentNodeLabel() != null) {
                return this.findNodeByNodeLabel(node.getParentNodeLabel());
            }
            return null;
        }

        private OnmsNode findNodeByNodeLabel(String label) {
            List nodes = BaseImporter.this.getNodeDao().findByLabel(label);
            if (nodes.size() == 1) {
                return (OnmsNode)nodes.iterator().next();
            }
            BaseImporter.this.log().error("Unable to locate a unique node using label " + label + " " + nodes.size() + " nodes found.  Ignoring relationship.");
            return null;
        }

        private OnmsNode findNodeByForeignId(String foreignSource, String foreignId) {
            return BaseImporter.this.getNodeDao().findByForeignId(foreignSource, foreignId);
        }
    }
}

