/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jni6;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.HostIsDownException;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.icmp.jni6.Jni6PingRequestId;
import org.opennms.netmgt.icmp.jni6.Jni6PingResponse;
import org.opennms.protocols.icmp6.ICMPv6EchoRequest;
import org.opennms.protocols.icmp6.ICMPv6Packet;
import org.opennms.protocols.icmp6.ICMPv6Socket;
import org.opennms.protocols.rt.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jni6PingRequest
implements Request<Jni6PingRequestId, Jni6PingRequest, Jni6PingResponse>,
EchoPacket {
    private static final Logger LOG = LoggerFactory.getLogger(Jni6PingRequest.class);
    private static long s_nextTid = 1L;
    private final Jni6PingRequestId m_id;
    private ICMPv6EchoRequest m_requestPacket = null;
    private final PingResponseCallback m_callback;
    private final int m_retries;
    private final long m_timeout;
    private final int m_packetsize;
    private long m_expiration = -1L;
    private final AtomicBoolean m_processed = new AtomicBoolean(false);

    public static final synchronized long getNextTID() {
        return s_nextTid++;
    }

    public Jni6PingRequest(Jni6PingRequestId id, long timeout, int retries, int packetsize, PingResponseCallback callback) {
        this.m_id = id;
        this.m_timeout = timeout;
        this.m_retries = retries;
        this.m_packetsize = packetsize;
        this.m_callback = callback;
    }

    public Jni6PingRequest(Inet6Address addr, int identifier, int sequenceNumber, long threadId, long timeout, int retries, int packetsize, PingResponseCallback cb) {
        this(new Jni6PingRequestId(addr, identifier, sequenceNumber, threadId), timeout, retries, packetsize, cb);
    }

    public Jni6PingRequest(Inet6Address addr, int identifier, int sequenceNumber, long timeout, int retries, int packetsize, PingResponseCallback cb) {
        this(addr, identifier, sequenceNumber, Jni6PingRequest.getNextTID(), timeout, retries, packetsize, cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processResponse(Jni6PingResponse reply) {
        try {
            LOG.debug("{}: Ping Response Received {}", (Object)System.currentTimeMillis(), (Object)this);
            this.m_callback.handleResponse((InetAddress)this.m_id.getAddress(), (EchoPacket)reply);
        }
        finally {
            this.setProcessed(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Jni6PingRequest processTimeout() {
        try {
            Jni6PingRequest returnval = null;
            if (this.isExpired()) {
                if (this.m_retries > 0) {
                    returnval = new Jni6PingRequest(this.m_id, this.m_timeout, this.m_retries - 1, this.m_packetsize, this.m_callback);
                    LOG.debug("{}: Retrying Ping Request {}", (Object)System.currentTimeMillis(), (Object)returnval);
                } else {
                    LOG.debug("{}: Ping Request Timed out {}", (Object)System.currentTimeMillis(), (Object)this);
                    this.m_callback.handleTimeout((InetAddress)this.m_id.getAddress(), (EchoPacket)this);
                }
            }
            Jni6PingRequest jni6PingRequest = returnval;
            return jni6PingRequest;
        }
        finally {
            this.setProcessed(true);
        }
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.m_expiration;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append("ID=").append(this.m_id).append(',');
        sb.append("Retries=").append(this.m_retries).append(",");
        sb.append("Timeout=").append(this.m_timeout).append(",");
        sb.append("Packet-Size=").append(this.m_packetsize).append(",");
        sb.append("Expiration=").append(this.m_expiration).append(',');
        sb.append("Callback=").append(this.m_callback);
        sb.append("]");
        return sb.toString();
    }

    public long getDelay(TimeUnit unit) {
        return unit.convert(this.m_expiration - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public int compareTo(Delayed request) {
        long otherDelay;
        long myDelay = this.getDelay(TimeUnit.MILLISECONDS);
        if (myDelay < (otherDelay = request.getDelay(TimeUnit.MILLISECONDS))) {
            return -1;
        }
        if (myDelay == otherDelay) {
            return 0;
        }
        return 1;
    }

    public Jni6PingRequestId getId() {
        return this.m_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processError(Throwable t) {
        try {
            this.m_callback.handleError((InetAddress)this.m_id.getAddress(), (EchoPacket)this, t);
        }
        finally {
            this.setProcessed(true);
        }
    }

    private void setProcessed(boolean processed) {
        this.m_processed.set(processed);
    }

    public boolean isProcessed() {
        return this.m_processed.get();
    }

    public void send(ICMPv6Socket socket) {
        try {
            this.m_requestPacket = this.createRequestPacket();
            LOG.debug("{}: Sending Ping Request: {}", (Object)System.currentTimeMillis(), (Object)this);
            byte[] data = this.m_requestPacket.toBytes();
            this.m_expiration = System.currentTimeMillis() + this.m_timeout;
            this.send(socket, new DatagramPacket(data, data.length, this.m_id.getAddress(), 0));
        }
        catch (Throwable t) {
            this.m_callback.handleError((InetAddress)this.m_id.getAddress(), (EchoPacket)this, t);
        }
    }

    private void send(ICMPv6Socket socket, DatagramPacket packet) throws IOException {
        try {
            socket.send(packet);
        }
        catch (IOException e) {
            if (e.getMessage().matches("sendto error \\(65, .*\\)")) {
                throw new NoRouteToHostException("No Route to Host " + this.m_id.getAddress() + ": " + e.getMessage());
            }
            if (e.getMessage().matches("sendto error \\(64, .*\\)")) {
                throw new HostIsDownException("Host " + this.m_id.getAddress() + " is down: " + e.getMessage());
            }
            throw e;
        }
    }

    private ICMPv6EchoRequest getRequestPacket() {
        return this.m_requestPacket;
    }

    private ICMPv6EchoRequest createRequestPacket() {
        return new ICMPv6EchoRequest(this.m_id.getIdentifier(), this.m_id.getSequenceNumber(), this.m_id.getThreadId(), this.m_packetsize);
    }

    public boolean isEchoReply() {
        return this.getRequestPacket().getType() == ICMPv6Packet.Type.EchoReply;
    }

    public int getIdentifier() {
        return this.getRequestPacket().getIdentifier();
    }

    public int getSequenceNumber() {
        return this.getRequestPacket().getSequenceNumber();
    }

    public long getThreadId() {
        return this.getRequestPacket().getThreadId();
    }

    public long getReceivedTimeNanos() {
        return this.getRequestPacket().getReceiveTime() * 1000000L;
    }

    public long getSentTimeNanos() {
        return this.getRequestPacket().getSentTime() * 1000000L;
    }

    public double elapsedTime(TimeUnit timeUnit) {
        double nanosPerUnit = TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        return (double)(this.getRequestPacket().getRoundTripTime() * 1000L) / nanosPerUnit;
    }
}

