/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jni;

import java.io.IOException;
import java.net.DatagramPacket;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.icmp.jni.JniPingRequest;
import org.opennms.netmgt.icmp.jni.JniPingResponse;
import org.opennms.protocols.icmp.ICMPEchoPacket;
import org.opennms.protocols.icmp.IcmpSocket;
import org.opennms.protocols.rt.Messenger;
import org.opennms.protocols.rt.ReplyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniIcmpMessenger
implements Messenger<JniPingRequest, JniPingResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(JniIcmpMessenger.class);
    private int m_pingerId;
    private IcmpSocket m_socket;

    public JniIcmpMessenger(int pingerId) throws IOException {
        this.m_pingerId = pingerId;
        this.m_socket = new IcmpSocket();
    }

    void processPackets(ReplyHandler<JniPingResponse> callback) {
        int pingerId = this.m_pingerId;
        while (true) {
            try {
                while (true) {
                    DatagramPacket packet;
                    JniPingResponse reply;
                    if (!(reply = JniIcmpMessenger.createPingResponse(packet = this.m_socket.receive())).isEchoReply() || reply.getIdentifier() != pingerId) {
                        continue;
                    }
                    callback.handleReply((Object)reply);
                }
            }
            catch (IOException e) {
                LOG.error("I/O Error occurred reading from ICMP Socket", (Throwable)e);
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            catch (Throwable e) {
                LOG.error("Unexpected Exception processing reply packet!", e);
                continue;
            }
            break;
        }
    }

    public void sendRequest(JniPingRequest request) {
        request.send(this.m_socket);
    }

    public void start(final ReplyHandler<JniPingResponse> callback) {
        Thread socketReader = new Thread("JNI-ICMP-" + this.m_pingerId + "-Socket-Reader"){

            @Override
            public void run() {
                Logging.putPrefix((String)"icmp");
                try {
                    JniIcmpMessenger.this.processPackets((ReplyHandler<JniPingResponse>)callback);
                }
                catch (Throwable t) {
                    LOG.error("Unexpected exception on Thread {}!", (Object)this, (Object)t);
                }
            }
        };
        socketReader.setDaemon(true);
        socketReader.start();
    }

    public static JniPingResponse createPingResponse(DatagramPacket packet) {
        ICMPEchoPacket pkt = new ICMPEchoPacket(packet.getData());
        if (pkt.getReceivedTime() == 0L) {
            pkt.setReceivedTime();
        }
        return new JniPingResponse(packet.getAddress(), pkt);
    }
}

