/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jni;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.HostIsDownException;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.icmp.jni.JniPingRequestId;
import org.opennms.netmgt.icmp.jni.JniPingResponse;
import org.opennms.protocols.icmp.ICMPEchoPacket;
import org.opennms.protocols.icmp.IcmpSocket;
import org.opennms.protocols.rt.Request;

public class JniPingRequest
implements Request<JniPingRequestId, JniPingRequest, JniPingResponse>,
EchoPacket {
    private static long s_nextTid = 1L;
    private final JniPingRequestId m_id;
    private ICMPEchoPacket m_requestPacket = null;
    private final PingResponseCallback m_callback;
    private final int m_retries;
    private final long m_timeout;
    private long m_expiration = -1L;
    private final ThreadCategory m_log;
    private final AtomicBoolean m_processed = new AtomicBoolean(false);

    public static final synchronized long getNextTID() {
        return s_nextTid++;
    }

    public JniPingRequest(JniPingRequestId id, long timeout, int retries, ThreadCategory log, PingResponseCallback callback) {
        this.m_id = id;
        this.m_timeout = timeout;
        this.m_retries = retries;
        this.m_log = log;
        this.m_callback = callback;
    }

    public JniPingRequest(InetAddress addr, int identifier, int sequenceNumber, long threadId, long timeout, int retries, ThreadCategory logger, PingResponseCallback cb) {
        this(new JniPingRequestId(addr, identifier, sequenceNumber, threadId), timeout, retries, logger, cb);
    }

    public JniPingRequest(InetAddress addr, int identifier, int sequenceNumber, long threadId, long timeout, int retries, PingResponseCallback cb) {
        this(addr, identifier, sequenceNumber, threadId, timeout, retries, ThreadCategory.getInstance(JniPingRequest.class), cb);
    }

    public JniPingRequest(InetAddress addr, int identifier, int sequenceNumber, long timeout, int retries, PingResponseCallback cb) {
        this(addr, identifier, sequenceNumber, JniPingRequest.getNextTID(), timeout, retries, cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processResponse(JniPingResponse reply) {
        try {
            this.m_log.debug(System.currentTimeMillis() + ": Ping Response Received " + this);
            this.m_callback.handleResponse(this.m_id.getAddress(), (EchoPacket)reply);
        }
        finally {
            this.setProcessed(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JniPingRequest processTimeout() {
        try {
            JniPingRequest returnval = null;
            if (this.isExpired()) {
                if (this.m_retries > 0) {
                    returnval = new JniPingRequest(this.m_id, this.m_timeout, this.m_retries - 1, this.m_log, this.m_callback);
                    this.m_log.debug(System.currentTimeMillis() + ": Retrying Ping Request " + returnval);
                } else {
                    this.m_log.debug(System.currentTimeMillis() + ": Ping Request Timed out " + this);
                    this.m_callback.handleTimeout(this.m_id.getAddress(), (EchoPacket)this);
                }
            }
            JniPingRequest jniPingRequest = returnval;
            return jniPingRequest;
        }
        finally {
            this.setProcessed(true);
        }
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.m_expiration;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append("ID=").append(this.m_id).append(',');
        sb.append("Retries=").append(this.m_retries).append(",");
        sb.append("Timeout=").append(this.m_timeout).append(",");
        sb.append("Expiration=").append(this.m_expiration).append(',');
        sb.append("Callback=").append(this.m_callback);
        sb.append("]");
        return sb.toString();
    }

    public long getDelay(TimeUnit unit) {
        return unit.convert(this.m_expiration - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public int compareTo(Delayed request) {
        long otherDelay;
        long myDelay = this.getDelay(TimeUnit.MILLISECONDS);
        if (myDelay < (otherDelay = request.getDelay(TimeUnit.MILLISECONDS))) {
            return -1;
        }
        if (myDelay == otherDelay) {
            return 0;
        }
        return 1;
    }

    public JniPingRequestId getId() {
        return this.m_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processError(Throwable t) {
        try {
            this.m_callback.handleError(this.m_id.getAddress(), (EchoPacket)this, t);
        }
        finally {
            this.setProcessed(true);
        }
    }

    private void setProcessed(boolean processed) {
        this.m_processed.set(processed);
    }

    public boolean isProcessed() {
        return this.m_processed.get();
    }

    public void send(IcmpSocket icmpSocket) {
        try {
            this.m_requestPacket = this.createRequestPacket();
            this.m_log.debug(System.currentTimeMillis() + ": Sending Ping Request: " + this);
            byte[] data = this.m_requestPacket.toBytes();
            this.m_expiration = System.currentTimeMillis() + this.m_timeout;
            this.send(icmpSocket, new DatagramPacket(data, data.length, this.m_id.getAddress(), 0));
        }
        catch (Throwable t) {
            this.m_callback.handleError(this.m_id.getAddress(), (EchoPacket)this, t);
        }
    }

    private void send(IcmpSocket icmpSocket, DatagramPacket packet) throws IOException {
        try {
            icmpSocket.send(packet);
        }
        catch (IOException e) {
            if (e.getMessage().matches("sendto error \\(65, .*\\)")) {
                throw new NoRouteToHostException("No Route to Host " + this.m_id.getAddress() + ": " + e.getMessage());
            }
            if (e.getMessage().matches("sendto error \\(64, .*\\)")) {
                throw new HostIsDownException("Host " + this.m_id.getAddress() + " is down: " + e.getMessage());
            }
            throw e;
        }
    }

    private ICMPEchoPacket getRequestPacket() {
        return this.m_requestPacket;
    }

    private ICMPEchoPacket createRequestPacket() {
        ICMPEchoPacket iPkt = new ICMPEchoPacket(this.m_id.getThreadId());
        iPkt.setIdentity((short)this.m_id.getIdentifier());
        iPkt.setSequenceId((short)this.m_id.getSequenceNumber());
        iPkt.computeChecksum();
        return iPkt;
    }

    public boolean isEchoReply() {
        return this.getRequestPacket().isEchoReply();
    }

    public int getIdentifier() {
        return this.getRequestPacket().getIdentity();
    }

    public int getSequenceNumber() {
        return this.getRequestPacket().getSequenceId();
    }

    public long getThreadId() {
        return this.getRequestPacket().getTID();
    }

    public long getReceivedTimeNanos() {
        return this.getRequestPacket().getReceivedTime();
    }

    public long getSentTimeNanos() {
        return this.getRequestPacket().getSentTime();
    }

    public double elapsedTime(TimeUnit timeUnit) {
        double nanosPerUnit = TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        return (double)(this.getRequestPacket().getPingRTT() * 1000L) / nanosPerUnit;
    }
}

