/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jna;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.opennms.jicmp.ipv6.ICMPv6EchoPacket;
import org.opennms.jicmp.ipv6.ICMPv6Packet;
import org.opennms.netmgt.icmp.EchoPacket;

class V6PingReply
extends ICMPv6EchoPacket
implements EchoPacket {
    private long m_receivedTimeNanos;

    public V6PingReply(ICMPv6Packet icmpPacket, long receivedTimeNanos) {
        super(icmpPacket);
        this.m_receivedTimeNanos = receivedTimeNanos;
    }

    public boolean isValid() {
        ByteBuffer content = this.getContentBuffer();
        return content.limit() >= 24 && 5724186650822398753L == content.getLong(0);
    }

    public boolean isEchoReply() {
        return ICMPv6Packet.Type.EchoReply.equals((Object)this.getType());
    }

    public int getIdentifier() {
        return super.getIdentifier();
    }

    public int getSequenceNumber() {
        return super.getSequenceNumber();
    }

    public long getThreadId() {
        return this.getContentBuffer().getLong(16);
    }

    public long getSentTimeNanos() {
        return this.getContentBuffer().getLong(8);
    }

    public long getReceivedTimeNanos() {
        return this.m_receivedTimeNanos;
    }

    public double elapsedTime(TimeUnit unit) {
        double nanosPerUnit = TimeUnit.NANOSECONDS.convert(1L, unit);
        return (double)this.elapsedTimeNanos() / nanosPerUnit;
    }

    protected long elapsedTimeNanos() {
        return this.getReceivedTimeNanos() - this.getSentTimeNanos();
    }
}

