/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jna;

import java.io.IOException;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.List;
import java.util.concurrent.Callable;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.icmp.ParallelPingResponseCallback;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.icmp.Pinger;
import org.opennms.netmgt.icmp.SinglePingResponseCallback;
import org.opennms.netmgt.icmp.jna.JnaIcmpMessenger;
import org.opennms.netmgt.icmp.jna.JnaPingReply;
import org.opennms.netmgt.icmp.jna.JnaPingRequest;
import org.opennms.protocols.rt.IDBasedRequestLocator;
import org.opennms.protocols.rt.Messenger;
import org.opennms.protocols.rt.Request;
import org.opennms.protocols.rt.RequestLocator;
import org.opennms.protocols.rt.RequestTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnaPinger
implements Pinger {
    private static final Logger LOG = LoggerFactory.getLogger(JnaPinger.class);
    private final int m_pingerId = new SecureRandom().nextInt(Short.MAX_VALUE);
    private RequestTracker<JnaPingRequest, JnaPingReply> m_pingTracker;
    private JnaIcmpMessenger m_messenger;

    private synchronized void initialize() throws Exception {
        if (this.m_pingTracker != null) {
            return;
        }
        try {
            this.m_messenger = new JnaIcmpMessenger(this.m_pingerId);
            this.m_pingTracker = (RequestTracker)Logging.withPrefix((String)"icmp", (Callable)new Callable<RequestTracker<JnaPingRequest, JnaPingReply>>(){

                @Override
                public RequestTracker<JnaPingRequest, JnaPingReply> call() throws Exception {
                    return new RequestTracker("JNA-ICMP-" + JnaPinger.this.m_pingerId, (Messenger)JnaPinger.this.m_messenger, (RequestLocator)new IDBasedRequestLocator());
                }
            });
            this.m_pingTracker.start();
        }
        catch (IOException e) {
            String errorMessage = e.getMessage().toLowerCase();
            if (errorMessage.contains("permission denied") || errorMessage.contains("operation not permitted")) {
                LOG.error("Permission error received while attempting to open ICMP socket. See https://wiki.opennms.org/wiki/ICMP for information on configuring ICMP for non-root.");
            }
            throw e;
        }
    }

    public void initialize4() throws Exception {
        this.initialize();
    }

    public void initialize6() throws Exception {
        this.initialize();
    }

    public boolean isV4Available() {
        try {
            this.initialize();
        }
        catch (Throwable t) {
            LOG.trace("Failed to initialize IPv4", t);
        }
        if (this.m_messenger == null) {
            return false;
        }
        return this.m_messenger.isV4Available();
    }

    public boolean isV6Available() {
        try {
            this.initialize();
        }
        catch (Throwable t) {
            LOG.trace("Failed to initialize IPv6", t);
        }
        if (this.m_messenger == null) {
            return false;
        }
        return this.m_messenger.isV6Available();
    }

    public void ping(InetAddress host, long timeout, int retries, int packetsize, int sequenceId, PingResponseCallback cb) throws Exception {
        this.initialize();
        this.m_pingTracker.sendRequest((Request)new JnaPingRequest(host, this.m_pingerId, sequenceId, timeout, retries, packetsize, cb));
    }

    public void ping(InetAddress host, long timeout, int retries, int sequenceId, PingResponseCallback cb) throws Exception {
        this.initialize();
        this.m_pingTracker.sendRequest((Request)new JnaPingRequest(host, this.m_pingerId, sequenceId, timeout, retries, 64, cb));
    }

    public Number ping(InetAddress host, long timeout, int retries, int packetsize) throws Exception {
        SinglePingResponseCallback cb = new SinglePingResponseCallback(host);
        this.ping(host, timeout, retries, packetsize, 1, (PingResponseCallback)cb);
        cb.waitFor();
        cb.rethrowError();
        return cb.getResponseTime();
    }

    public Number ping(InetAddress host, long timeout, int retries) throws Exception {
        return this.ping(host, timeout, retries, 64);
    }

    public Number ping(InetAddress host) throws Exception {
        return this.ping(host, 800L, 2);
    }

    public List<Number> parallelPing(InetAddress host, int count, long timeout, long pingInterval, int size) throws Exception {
        this.initialize();
        ParallelPingResponseCallback cb = new ParallelPingResponseCallback(count);
        long threadId = JnaPingRequest.getNextTID();
        for (int seqNum = 0; seqNum < count; ++seqNum) {
            JnaPingRequest request = new JnaPingRequest(host, this.m_pingerId, seqNum, threadId, timeout == 0L ? 800L : timeout, 0, size, (PingResponseCallback)cb);
            this.m_pingTracker.sendRequest((Request)request);
            Thread.sleep(pingInterval);
        }
        cb.waitFor();
        return cb.getResponseTimes();
    }

    public List<Number> parallelPing(InetAddress host, int count, long timeout, long pingInterval) throws Exception {
        return this.parallelPing(host, count, timeout, pingInterval, 64);
    }

    public void setAllowFragmentation(boolean allow) throws Exception {
        this.initialize();
        this.m_messenger.setAllowFragmentation(allow);
    }

    public void setTrafficClass(int tc) throws Exception {
        this.initialize();
        this.m_messenger.setTrafficClass(tc);
    }
}

