/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.commands;

import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.netmgt.icmp.proxy.LocationAwarePingClient;
import org.opennms.netmgt.icmp.proxy.PingRequest;
import org.opennms.netmgt.icmp.proxy.PingRequestBuilder;
import org.opennms.netmgt.icmp.proxy.PingSequence;
import org.opennms.netmgt.icmp.proxy.PingStringUtils;
import org.opennms.netmgt.icmp.proxy.PingSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="ping", name="ping", description="Ping")
public class PingCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(PingCommand.class);
    private LocationAwarePingClient locationAwarePingClient;
    @Option(name="-l", aliases={"--location"}, description="Location", required=false, multiValued=false)
    String m_location = "Default";
    @Option(name="-c", aliases={"--count"}, description="number of requests")
    int m_count = 1;
    @Argument(index=0, name="host", description="Hostname or IP Address of the system to walk", required=true, multiValued=false)
    String m_host;

    protected Object doExecute() throws Exception {
        LOG.debug("ping:ping {} {}", (Object)(this.m_location != null ? "-l " + this.m_location : ""), (Object)this.m_host);
        InetAddress byName = InetAddress.getByName(this.m_host);
        PingRequestBuilder.Callback callback = (newSequence, summary) -> {
            if (this.m_count > 1) {
                if (summary.getSequences().size() == 0) {
                    System.out.println(PingStringUtils.renderHeader((PingSummary)summary));
                }
                if (newSequence != null) {
                    System.out.println(PingStringUtils.renderSequence((PingRequest)summary.getRequest(), (PingSequence)newSequence));
                }
                if (summary.isComplete()) {
                    System.out.println(PingStringUtils.renderSummary((PingSummary)summary));
                }
            }
        };
        CompletableFuture future = this.locationAwarePingClient.ping(byName).withLocation(this.m_location).withNumberOfRequests(this.m_count).withProgressCallback(callback).execute();
        while (true) {
            try {
                PingSummary summary2 = (PingSummary)future.get(1L, TimeUnit.SECONDS);
                if (this.m_count != 1) break;
                System.out.println(String.format("PING: %s %.3f ms", byName, summary2.getSequence(0).getResponse().getRtt()));
            }
            catch (TimeoutException timeoutException) {
                System.out.print(".");
                continue;
            }
            break;
        }
        return null;
    }

    public void setLocationAwarePingClient(LocationAwarePingClient locationAwarePingClient) {
        this.locationAwarePingClient = locationAwarePingClient;
    }
}

