/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.commands;

import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.netmgt.icmp.proxy.LocationAwarePingClient;
import org.opennms.netmgt.icmp.proxy.PingSweepSummary;

@Command(scope="ping", name="sweep", description="Ping-Sweep")
public class PingSweepCommand
extends OsgiCommandSupport {
    private LocationAwarePingClient locationAwarePingClient;
    @Option(name="-l", aliases={"--location"}, description="location")
    String m_location;
    @Option(name="-r", aliases={"--retries"}, description="number of retries")
    int m_retries = 2;
    @Option(name="-t", aliases={"--timeout"}, description="timeout in msec")
    int m_timeout = 800;
    @Option(name="-p", aliases={"--packetsize"}, description="packet size")
    int m_packetsize = 64;
    @Option(name="-s", aliases={"--pps"}, description="packer per second")
    double m_packetsPerSecond = 1.0;
    @Argument(index=0, name="begin", description="begin address of the IP range to be pinged", required=true, multiValued=false)
    String m_begin;
    @Argument(index=1, name="end", description="end address of the IP range to be pinged", required=true, multiValued=false)
    String m_end;

    protected Object doExecute() throws Exception {
        InetAddress begin = InetAddress.getByName(this.m_begin);
        InetAddress end = InetAddress.getByName(this.m_end);
        System.out.printf("Pinging hosts from %s to %s with:\n", begin.getHostAddress(), end.getHostAddress());
        if (this.m_location != null) {
            System.out.printf("\tLocation: %s\n", this.m_location);
        }
        System.out.printf("\tRetries: %d\n", this.m_retries);
        System.out.printf("\tTimeout: %d\n", this.m_timeout);
        System.out.printf("\tPacket size: %d\n", this.m_packetsize);
        System.out.printf("\tPackets per second: %f\n", this.m_packetsPerSecond);
        CompletableFuture future = this.locationAwarePingClient.sweep().withLocation(this.m_location).withRange(begin, end, this.m_retries, (long)this.m_timeout, TimeUnit.MILLISECONDS).withPacketSize(this.m_packetsize).withPacketsPerSecond(this.m_packetsPerSecond).execute();
        while (true) {
            try {
                try {
                    PingSweepSummary summary = (PingSweepSummary)future.get(1L, TimeUnit.SECONDS);
                    if (summary.getResponses().isEmpty()) {
                        System.out.printf("\n\nNone of the IP addresses responsed to our pings.\n", new Object[0]);
                        break;
                    }
                    System.out.printf("\n\nIP Address\tRound-trip time\n", new Object[0]);
                    summary.getResponses().forEach((address, rtt) -> System.out.printf("%s\t%.3f ms\n", address.getHostAddress(), rtt));
                }
                catch (InterruptedException e) {
                    System.out.println("\n\nInterrupted.");
                }
                catch (ExecutionException e) {
                    System.out.printf("\n\nPing Sweep failed with: %s\n", e);
                }
            }
            catch (TimeoutException timeoutException) {
                System.out.print(".");
                continue;
            }
            break;
        }
        return null;
    }

    public void setLocationAwarePingClient(LocationAwarePingClient locationAwarePingClient) {
        this.locationAwarePingClient = locationAwarePingClient;
    }
}

