/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.best;

import java.net.InetAddress;
import java.util.Arrays;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.icmp.AbstractPingerFactory;
import org.opennms.netmgt.icmp.NullPinger;
import org.opennms.netmgt.icmp.Pinger;
import org.opennms.netmgt.icmp.best.PingerMatch;
import org.opennms.netmgt.icmp.jna.JnaPinger;
import org.opennms.netmgt.icmp.jni.JniPinger;
import org.opennms.netmgt.icmp.jni6.Jni6Pinger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestMatchPingerFactory
extends AbstractPingerFactory {
    private static Logger LOG = LoggerFactory.getLogger(BestMatchPingerFactory.class);
    private static InetAddress LOOPBACK = InetAddressUtils.getLocalLoopbackAddress().orElse(InetAddressUtils.addr((String)"127.0.0.1"));
    Class<? extends Pinger> m_pingerClass = null;

    public Class<? extends Pinger> getPingerClass() {
        this.initialize();
        return this.m_pingerClass;
    }

    private static PingerMatch tryPinger(Class<? extends Pinger> pingerClass) {
        Pinger pinger;
        boolean v4 = false;
        boolean v6 = false;
        try {
            pinger = pingerClass.newInstance();
        }
        catch (Throwable t) {
            LOG.info("Failed to get instance of {}: {}", pingerClass, (Object)t.getMessage());
            LOG.trace("Failed to get instance of {}.", pingerClass, (Object)t);
            return PingerMatch.NONE;
        }
        try {
            if (pinger.isV4Available()) {
                pinger.initialize4();
                v4 = true;
            }
        }
        catch (Throwable t) {
            LOG.info("Failed to initialize {} for IPv4: ", pingerClass, (Object)t.getMessage());
            LOG.trace("Failed to initialize {} for IPv4.", pingerClass, (Object)t);
        }
        try {
            if (pinger.isV6Available()) {
                pinger.initialize6();
                v6 = true;
            }
        }
        catch (Throwable t) {
            LOG.info("Failed to initialize {} for IPv4: {}", pingerClass, (Object)t.getMessage());
            LOG.trace("Failed to initialize {} for IPv4.", pingerClass, (Object)t);
        }
        long timeout = Long.valueOf(System.getProperty("org.opennms.netmgt.icmp.best.timeout", "500"), 10);
        for (InetAddress tryme : new InetAddress[]{LOOPBACK, InetAddressUtils.addr((String)"127.0.0.1"), InetAddressUtils.addr((String)"::1")}) {
            try {
                Number result = pinger.ping(tryme, timeout, 0);
                if (result == null) {
                    throw new IllegalStateException("No result pinging localhost.");
                }
                if (v4 && v6) {
                    return PingerMatch.IPv46;
                }
                if (v6) {
                    return PingerMatch.IPv6;
                }
                if (!v4) continue;
                return PingerMatch.IPv4;
            }
            catch (Throwable t) {
                LOG.info("Found pinger {}, but it was unable to ping localhost: {}", pingerClass, (Object)t.getMessage());
                LOG.trace("Pinger failure:", t);
            }
        }
        return PingerMatch.NONE;
    }

    static Class<? extends Pinger> findPinger() {
        String pingerClassStr = System.getProperty("org.opennms.netmgt.icmp.pingerClass");
        if (pingerClassStr != null) {
            try {
                Class<Pinger> pingerClass = Class.forName(pingerClassStr).asSubclass(Pinger.class);
                LOG.warn("Not scanning for best pinger because explicit pinger class has been set: {}", (Object)pingerClassStr);
                return pingerClass;
            }
            catch (Throwable t) {
                LOG.error("org.opennms.netmgt.icmp.pingerClass is set ({}), but it failed to initialize! Erroring out.", (Object)pingerClassStr, (Object)t);
                throw new IllegalStateException("Unable to initialize pinger class set in org.opennms.netmgt.icmp.pingerClass", t);
            }
        }
        PingerMatch match = PingerMatch.NONE;
        Class pinger = NullPinger.class;
        LOG.info("Searching for best available pinger...");
        for (Class pingerClass : Arrays.asList(JniPinger.class, Jni6Pinger.class, JnaPinger.class)) {
            PingerMatch tried = BestMatchPingerFactory.tryPinger(pingerClass);
            if (tried.compareTo(match) <= 0) continue;
            match = tried;
            pinger = pingerClass;
        }
        LOG.info("Best available pinger is: {}", pinger);
        return pinger;
    }

    private void initialize() {
        if (this.m_pingerClass == null) {
            Pinger defaultPinger = (Pinger)m_pingers.getIfPresent((Object)1);
            this.m_pingerClass = defaultPinger != null ? defaultPinger.getClass() : BestMatchPingerFactory.findPinger();
        }
    }
}

