/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.best;

import java.util.Arrays;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.icmp.AbstractPingerFactory;
import org.opennms.netmgt.icmp.NullPinger;
import org.opennms.netmgt.icmp.Pinger;
import org.opennms.netmgt.icmp.best.PingerMatch;
import org.opennms.netmgt.icmp.jna.JnaPinger;
import org.opennms.netmgt.icmp.jni.JniPinger;
import org.opennms.netmgt.icmp.jni6.Jni6Pinger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestMatchPingerFactory
extends AbstractPingerFactory {
    private static Logger LOG = LoggerFactory.getLogger(BestMatchPingerFactory.class);
    Class<? extends Pinger> m_pingerClass = null;

    public Class<? extends Pinger> getPingerClass() {
        this.initialize();
        return this.m_pingerClass;
    }

    private static PingerMatch tryPinger(Class<? extends Pinger> pingerClass) {
        Pinger pinger;
        boolean v4 = false;
        boolean v6 = false;
        try {
            pinger = pingerClass.newInstance();
        }
        catch (Throwable t) {
            LOG.info("Failed to get instance of {}.", pingerClass, (Object)t);
            return PingerMatch.NONE;
        }
        try {
            if (pinger.isV4Available()) {
                v4 = true;
            }
        }
        catch (Throwable t) {
            LOG.info("Failed to initialize {} for IPv4.", pingerClass, (Object)t);
        }
        try {
            if (pinger.isV6Available()) {
                v6 = true;
            }
        }
        catch (Throwable t) {
            LOG.info("Failed to initialize {} for IPv4.", pingerClass, (Object)t);
        }
        try {
            long timeout = Long.valueOf(System.getProperty("org.opennms.netmgt.icmp.best.timeout", "500"), 10);
            Number result = pinger.ping(InetAddressUtils.getLocalHostAddress(), timeout, 0);
            if (result == null) {
                throw new IllegalStateException("No result pinging localhost.");
            }
        }
        catch (Throwable t) {
            LOG.info("Found pinger {}, but it was unable to ping localhost.", pingerClass, (Object)t);
            return PingerMatch.NONE;
        }
        if (v4 && v6) {
            return PingerMatch.IPv46;
        }
        if (v6) {
            return PingerMatch.IPv6;
        }
        if (v4) {
            return PingerMatch.IPv4;
        }
        return PingerMatch.NONE;
    }

    static Class<? extends Pinger> findPinger() {
        PingerMatch match = PingerMatch.NONE;
        Class pinger = NullPinger.class;
        LOG.info("Searching for best available pinger...");
        for (Class pingerClass : Arrays.asList(Jni6Pinger.class, JniPinger.class, JnaPinger.class)) {
            PingerMatch tried = BestMatchPingerFactory.tryPinger(pingerClass);
            if (tried.compareTo(match) <= 0) continue;
            match = tried;
            pinger = pingerClass;
        }
        LOG.info("Best available pinger is: {}", pinger);
        return pinger;
    }

    private void initialize() {
        if (this.m_pingerClass == null) {
            Pinger defaultPinger = (Pinger)m_pingers.getIfPresent((Object)1);
            this.m_pingerClass = defaultPinger != null ? defaultPinger.getClass() : BestMatchPingerFactory.findPinger();
        }
    }
}

