/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy;

import java.util.List;
import java.util.Objects;
import java.util.stream.LongStream;
import org.opennms.netmgt.icmp.proxy.PingSequence;

class PingSummaryCalculator {
    private final List<PingSequence> sequences;

    PingSummaryCalculator(List<PingSequence> pingSequenceList) {
        this.sequences = Objects.requireNonNull(pingSequenceList);
    }

    int getPacketsTransmitted() {
        return this.sequences.size();
    }

    double getPacketLoss() {
        return 1.0 - (double)this.getPacketsReceived() / (double)this.getPacketsTransmitted();
    }

    int getPacketsReceived() {
        return (int)this.sequences.stream().filter(eachSequence -> eachSequence.isSuccess()).count();
    }

    long getMin() {
        return this.getDiffTimeNanos().min().orElse(0L);
    }

    double getAvg() {
        return this.getDiffTimeNanos().average().orElse(0.0);
    }

    long getMax() {
        return this.getDiffTimeNanos().max().orElse(0L);
    }

    double getStdDev() {
        return this.getAvg() - (double)this.getMin();
    }

    private LongStream getDiffTimeNanos() {
        return this.sequences.stream().filter(eachSequence -> eachSequence.isSuccess()).mapToLong(eachSequence -> (long)eachSequence.getResponse().getRtt());
    }
}

