/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp;

import org.opennms.netmgt.icmp.Pinger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PingerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PingerFactory.class);
    private static Pinger m_pinger;

    public static Pinger getInstance() {
        if (m_pinger == null) {
            String pingerClassName = System.getProperty("org.opennms.netmgt.icmp.pingerClass", "org.opennms.netmgt.icmp.jni6.Jni6Pinger");
            Class<Pinger> clazz = null;
            try {
                clazz = Class.forName(pingerClassName).asSubclass(Pinger.class);
                m_pinger = clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                IllegalArgumentException ex = new IllegalArgumentException("Unable to find class named " + pingerClassName, e);
                LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
                throw ex;
            }
            catch (InstantiationException e) {
                IllegalArgumentException ex = new IllegalArgumentException("Error trying to create pinger of type " + clazz, e);
                LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
                throw ex;
            }
            catch (IllegalAccessException e) {
                IllegalArgumentException ex = new IllegalArgumentException("Unable to create pinger of type " + clazz + ".  It does not appear to have a public constructor", e);
                LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
                throw ex;
            }
            catch (Throwable e) {
                IllegalArgumentException ex = new IllegalArgumentException("Unexpected exception thrown while trying to create pinger of type " + clazz, e);
                LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
                throw ex;
            }
        }
        return m_pinger;
    }

    public static void setInstance(Pinger pinger) {
        m_pinger = pinger;
    }

    protected static void reset() {
        m_pinger = null;
    }
}

