/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ping;

import java.net.InetAddress;
import org.opennms.core.concurrent.BarrierSignaler;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ping.PingResponseCallback;
import org.opennms.protocols.icmp.ICMPEchoPacket;

public class SinglePingResponseCallback
implements PingResponseCallback {
    private BarrierSignaler bs = new BarrierSignaler(1);
    private Throwable error = null;
    private Long responseTime = null;
    private InetAddress m_host;

    public SinglePingResponseCallback(InetAddress host) {
        this.m_host = host;
    }

    public void handleResponse(InetAddress address, ICMPEchoPacket packet) {
        this.info("got response for address " + address + ", thread " + packet.getTID() + ", seq " + packet.getSequenceId() + " with a responseTime " + packet.getPingRTT());
        this.responseTime = packet.getPingRTT();
        this.bs.signalAll();
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void handleTimeout(InetAddress address, ICMPEchoPacket packet) {
        this.info("timed out pinging address " + address + ", thread " + packet.getTID() + ", seq " + packet.getSequenceId());
        this.bs.signalAll();
    }

    public void handleError(InetAddress address, ICMPEchoPacket pr, Throwable t) {
        this.info("an error occurred pinging " + address, t);
        this.error = t;
        this.bs.signalAll();
    }

    public void waitFor(long timeout) throws InterruptedException {
        this.bs.waitFor(timeout);
    }

    public void waitFor() throws InterruptedException {
        this.info("waiting for ping to " + this.m_host + " to finish");
        this.bs.waitFor();
        this.info("finished waiting for ping to " + this.m_host + " to finish");
    }

    public Long getResponseTime() {
        return this.responseTime;
    }

    public void info(String msg) {
        this.log().info(msg);
    }

    public void info(String msg, Throwable t) {
        this.log().info(msg, t);
    }
}

