/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ping;

import java.net.InetAddress;
import org.opennms.netmgt.ping.PingReply;

public class PingRequestId {
    InetAddress m_addr;
    long m_tid;
    short m_seqId;

    public PingRequestId(InetAddress addr, long tid, short seqId) {
        this.m_addr = addr;
        this.m_tid = tid;
        this.m_seqId = seqId;
    }

    public PingRequestId(PingReply reply) {
        this(reply.getAddress(), reply.getPacket().getTID(), reply.getPacket().getSequenceId());
    }

    public InetAddress getAddress() {
        return this.m_addr;
    }

    public long getTid() {
        return this.m_tid;
    }

    public short getSequenceId() {
        return this.m_seqId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PingRequestId) {
            PingRequestId id = (PingRequestId)obj;
            return this.getAddress().equals(id.getAddress()) && this.getTid() == id.getTid() && this.getSequenceId() == id.getSequenceId();
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.m_addr.hashCode();
        hash = hash * 31 + (int)(this.m_tid >>> 32);
        hash = hash * 31 + (int)this.m_tid;
        hash = hash * 31 + this.m_seqId;
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append('[');
        buf.append("addr = ").append(this.m_addr);
        buf.append(", ");
        buf.append("tid = ").append(this.m_tid);
        buf.append(", ");
        buf.append("seqId = ").append(this.m_seqId);
        buf.append(']');
        return buf.toString();
    }
}

