/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp;

import java.net.InetAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinglePingResponseCallback
implements PingResponseCallback {
    private static final Logger LOG = LoggerFactory.getLogger(SinglePingResponseCallback.class);
    private Long m_responseTime = null;
    private InetAddress m_host;
    private Throwable m_error = null;
    private CountDownLatch m_latch = new CountDownLatch(1);

    public SinglePingResponseCallback(InetAddress host) {
        this.m_host = host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResponse(InetAddress address, EchoPacket response) {
        try {
            this.info("got response for address " + address + ", thread " + response.getIdentifier() + ", seq " + response.getSequenceNumber() + " with a responseTime " + response.elapsedTime(TimeUnit.MILLISECONDS) + "ms");
            this.m_responseTime = Math.round(response.elapsedTime(TimeUnit.MICROSECONDS));
        }
        finally {
            this.m_latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTimeout(InetAddress address, EchoPacket request) {
        try {
            assert (request != null);
            this.info("timed out pinging address " + address + ", thread " + request.getIdentifier() + ", seq " + request.getSequenceNumber());
        }
        finally {
            this.m_latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleError(InetAddress address, EchoPacket request, Throwable t) {
        try {
            this.m_error = t;
            this.info("an error occurred pinging " + address, t);
        }
        finally {
            this.m_latch.countDown();
        }
    }

    public void waitFor(long timeout) throws InterruptedException {
        this.m_latch.await(timeout, TimeUnit.MILLISECONDS);
    }

    public void waitFor() throws InterruptedException {
        this.info("waiting for ping to " + this.m_host + " to finish");
        this.m_latch.await();
        this.info("finished waiting for ping to " + this.m_host + " to finish");
    }

    public void rethrowError() throws Exception {
        if (this.m_error instanceof Error) {
            throw (Error)this.m_error;
        }
        if (this.m_error instanceof Exception) {
            throw (Exception)this.m_error;
        }
    }

    public Long getResponseTime() {
        return this.m_responseTime;
    }

    public Throwable getError() {
        return this.m_error;
    }

    public void info(String msg) {
        LOG.info(msg);
    }

    public void info(String msg, Throwable t) {
        LOG.info(msg, t);
    }
}

