/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogPrefixPreservingPingResponseCallback
implements PingResponseCallback {
    private static final Logger LOG = LoggerFactory.getLogger(LogPrefixPreservingPingResponseCallback.class);
    private final PingResponseCallback m_cb;
    private final Map m_mdc = LogPrefixPreservingPingResponseCallback.getCopyOfContextMap();

    public LogPrefixPreservingPingResponseCallback(PingResponseCallback cb) {
        this.m_cb = cb;
    }

    private static Map getCopyOfContextMap() {
        return MDC.getCopyOfContextMap();
    }

    private static void setContextMap(Map map) {
        if (map == null) {
            MDC.clear();
        } else {
            MDC.setContextMap((Map)map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleError(InetAddress address, EchoPacket request, Throwable t) {
        Map mdc = LogPrefixPreservingPingResponseCallback.getCopyOfContextMap();
        try {
            LogPrefixPreservingPingResponseCallback.setContextMap(this.m_mdc);
            this.m_cb.handleError(address, request, t);
        }
        finally {
            LogPrefixPreservingPingResponseCallback.setContextMap(mdc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResponse(InetAddress address, EchoPacket response) {
        Map mdc = LogPrefixPreservingPingResponseCallback.getCopyOfContextMap();
        try {
            LogPrefixPreservingPingResponseCallback.setContextMap(this.m_mdc);
            this.m_cb.handleResponse(address, response);
        }
        finally {
            LogPrefixPreservingPingResponseCallback.setContextMap(mdc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTimeout(InetAddress address, EchoPacket request) {
        Map mdc = LogPrefixPreservingPingResponseCallback.getCopyOfContextMap();
        try {
            LogPrefixPreservingPingResponseCallback.setContextMap(this.m_mdc);
            this.m_cb.handleTimeout(address, request);
        }
        finally {
            LogPrefixPreservingPingResponseCallback.setContextMap(mdc);
        }
    }
}

