/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.Set;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DnsRecord {
    private static final Logger LOG = LoggerFactory.getLogger(DnsRecord.class);
    private InetAddress m_ip;
    private String m_hostname;
    private String m_zone;

    DnsRecord(OnmsNode node) {
        OnmsIpInterface primaryInterface = node.getPrimaryInterface();
        if (primaryInterface == null) {
            LOG.debug("Constructor: no primary interface found for nodeid: {}", (Object)node.getNodeId());
            Set ipInterfaces = node.getIpInterfaces();
            Iterator iterator = ipInterfaces.iterator();
            if (iterator.hasNext()) {
                OnmsIpInterface onmsIpInterface = (OnmsIpInterface)iterator.next();
                this.m_ip = onmsIpInterface.getIpAddress();
            }
        } else {
            LOG.debug("Constructor: primary interface found for nodeid: {}", (Object)node.getNodeId());
            this.m_ip = primaryInterface.getIpAddress();
        }
        LOG.debug("Constructor: set ip address: {}", (Object)this.m_ip);
        this.m_hostname = node.getLabel() + ".";
        LOG.debug("Constructor: set hostname: {}", (Object)this.m_hostname);
        this.m_zone = this.m_hostname.substring(this.m_hostname.indexOf(46) + 1);
        LOG.debug("Constructor: set zone: {}", (Object)this.m_zone);
    }

    public InetAddress getIp() {
        return this.m_ip;
    }

    public String getZone() {
        return this.m_zone;
    }

    public String getHostname() {
        return this.m_hostname;
    }
}

