/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.client.rpc;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.detector.client.rpc.DetectorAttributeDTO;

@XmlRootElement(name="detector-request")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DetectorRequestDTO
implements DetectRequest,
RpcRequest {
    @XmlAttribute(name="location")
    private String location;
    @XmlAttribute(name="class-name")
    private String className;
    @XmlAttribute(name="address")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress address;
    @XmlElement(name="detector-attribute")
    private List<DetectorAttributeDTO> detectorAttributes = new ArrayList<DetectorAttributeDTO>();
    @XmlElement(name="runtime-attribute")
    private List<DetectorAttributeDTO> runtimeAttributes = new ArrayList<DetectorAttributeDTO>();

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public List<DetectorAttributeDTO> getDetectorAttributes() {
        return this.detectorAttributes;
    }

    public void setDetectorAttributes(List<DetectorAttributeDTO> attributes) {
        this.detectorAttributes = attributes;
    }

    public void addDetectorAttribute(String key, String value) {
        this.detectorAttributes.add(new DetectorAttributeDTO(key, value));
    }

    public void addDetectorAttributes(Map<String, String> attributes) {
        attributes.entrySet().stream().forEach(e -> this.addDetectorAttribute((String)e.getKey(), (String)e.getValue()));
    }

    public Map<String, String> getAttributeMap() {
        return this.detectorAttributes.stream().collect(Collectors.toMap(DetectorAttributeDTO::getKey, DetectorAttributeDTO::getValue));
    }

    public void setRuntimeAttributes(List<DetectorAttributeDTO> attributes) {
        this.runtimeAttributes = attributes;
    }

    public void addRuntimeAttribute(String key, String value) {
        this.runtimeAttributes.add(new DetectorAttributeDTO(key, value));
    }

    public void addRuntimeAttributes(Map<String, String> attributes) {
        attributes.entrySet().stream().forEach(e -> this.addRuntimeAttribute((String)e.getKey(), (String)e.getValue()));
    }

    public Map<String, String> getRuntimeAttributes() {
        HashMap<String, String> runtimeAttributeMap = new HashMap<String, String>();
        for (DetectorAttributeDTO agentAttribute : this.runtimeAttributes) {
            runtimeAttributeMap.put(agentAttribute.getKey(), agentAttribute.getValue());
        }
        return runtimeAttributeMap;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public Long getTimeToLiveMs() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.location, this.detectorAttributes, this.runtimeAttributes, this.className, this.address);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DetectorRequestDTO other = (DetectorRequestDTO)obj;
        return Objects.equals(this.location, other.location) && Objects.equals(this.location, other.location) && Objects.equals(this.detectorAttributes, other.detectorAttributes) && Objects.equals(this.runtimeAttributes, other.runtimeAttributes) && Objects.equals(this.className, other.className) && Objects.equals(this.address, other.address);
    }
}

