/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.dns.client.rpc;

import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.rpc.xml.AbstractXmlRpcModule;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.dns.client.rpc.DnsLookupRequestDTO;
import org.opennms.netmgt.provision.dns.client.rpc.DnsLookupResponseDTO;
import org.opennms.netmgt.provision.dns.client.rpc.QueryType;

public class DnsLookupClientRpcModule
extends AbstractXmlRpcModule<DnsLookupRequestDTO, DnsLookupResponseDTO> {
    public static final String RPC_MODULE_ID = "DNS";

    public DnsLookupClientRpcModule() {
        super(DnsLookupRequestDTO.class, DnsLookupResponseDTO.class);
    }

    public String getId() {
        return RPC_MODULE_ID;
    }

    public CompletableFuture<DnsLookupResponseDTO> execute(DnsLookupRequestDTO request) {
        String hostRequest = request.getHostRequest();
        QueryType queryType = request.getQueryType();
        DnsLookupResponseDTO dto = new DnsLookupResponseDTO();
        try {
            InetAddress addr = InetAddressUtils.addr((String)hostRequest);
            if (queryType.equals((Object)QueryType.LOOKUP)) {
                dto.setHostResponse(addr.getHostAddress());
            } else if (queryType.equals((Object)QueryType.REVERSE_LOOKUP)) {
                dto.setHostResponse(addr.getCanonicalHostName());
            }
        }
        catch (Exception e) {
            dto.setFailureMessage(e.getMessage());
        }
        CompletableFuture<DnsLookupResponseDTO> response = new CompletableFuture<DnsLookupResponseDTO>();
        response.complete(dto);
        return response;
    }
}

