/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.client.rpc;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.opennms.core.rpc.xml.AbstractXmlRpcModule;
import org.opennms.netmgt.provision.AsyncServiceDetector;
import org.opennms.netmgt.provision.DetectFuture;
import org.opennms.netmgt.provision.DetectFutureListener;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.DetectResults;
import org.opennms.netmgt.provision.ServiceDetector;
import org.opennms.netmgt.provision.SyncServiceDetector;
import org.opennms.netmgt.provision.detector.client.rpc.DetectorRequestDTO;
import org.opennms.netmgt.provision.detector.client.rpc.DetectorResponseDTO;
import org.opennms.netmgt.provision.detector.registry.api.ServiceDetectorRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DetectorClientRpcModule
extends AbstractXmlRpcModule<DetectorRequestDTO, DetectorResponseDTO> {
    public static final String RPC_MODULE_ID = "Detect";
    @Autowired
    private ServiceDetectorRegistry serviceDetectorRegistry;
    @Autowired
    @Qualifier(value="scanExecutor")
    private Executor executor;

    public DetectorClientRpcModule() {
        super(DetectorRequestDTO.class, DetectorResponseDTO.class);
    }

    public CompletableFuture<DetectorResponseDTO> execute(DetectorRequestDTO request) {
        Map<String, String> attributes;
        String className = request.getClassName();
        ServiceDetector detector = this.serviceDetectorRegistry.getDetectorByClassName(className, attributes = request.getAttributeMap());
        if (detector == null) {
            throw new IllegalArgumentException("No detector found with class name '" + className + "'.");
        }
        return this.detectService(detector, request);
    }

    private CompletableFuture<DetectorResponseDTO> detectService(ServiceDetector detector, final DetectRequest detectRequest) {
        detector.init();
        if (detector instanceof SyncServiceDetector) {
            final SyncServiceDetector syncDetector = (SyncServiceDetector)detector;
            return CompletableFuture.supplyAsync(new Supplier<DetectorResponseDTO>(){

                @Override
                public DetectorResponseDTO get() {
                    try {
                        DetectorResponseDTO detectorResponseDTO = new DetectorResponseDTO(syncDetector.detect(detectRequest));
                        return detectorResponseDTO;
                    }
                    catch (Throwable t) {
                        DetectorResponseDTO detectorResponseDTO = new DetectorResponseDTO(t);
                        return detectorResponseDTO;
                    }
                    finally {
                        syncDetector.dispose();
                    }
                }
            }, this.executor);
        }
        if (detector instanceof AsyncServiceDetector) {
            final CompletableFuture<DetectorResponseDTO> future = new CompletableFuture<DetectorResponseDTO>();
            AsyncServiceDetector asyncDetector = (AsyncServiceDetector)detector;
            try {
                DetectFuture detectFuture = asyncDetector.detect(detectRequest);
                detectFuture.addListener((DetectFutureListener)new DetectFutureListener<DetectFuture>(){

                    public void operationComplete(DetectFuture detectFuture) {
                        if (detectFuture.getException() != null) {
                            future.complete(new DetectorResponseDTO(detectFuture.getException()));
                        } else {
                            future.complete(new DetectorResponseDTO((DetectResults)detectFuture));
                        }
                    }
                });
            }
            catch (Throwable t) {
                DetectorResponseDTO responseDTO = new DetectorResponseDTO();
                responseDTO.setDetected(false);
                responseDTO.setFailureMessage(t.getMessage());
                future.complete(responseDTO);
            }
            return future;
        }
        throw new IllegalArgumentException("Unsupported detector type.");
    }

    public String getId() {
        return RPC_MODULE_ID;
    }

    public void setServiceDetectorRegistry(ServiceDetectorRegistry serviceDetectorRegistry) {
        this.serviceDetectorRegistry = serviceDetectorRegistry;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }
}

