/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.client.rpc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.rpc.api.RpcResponse;
import org.opennms.netmgt.provision.DetectResults;
import org.opennms.netmgt.provision.detector.client.rpc.DetectorAttributeDTO;

@XmlRootElement(name="detector-response")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DetectorResponseDTO
implements DetectResults,
RpcResponse {
    @XmlAttribute(name="detected")
    private boolean detected;
    @XmlAttribute(name="failure-message")
    private String failureMesage;
    @XmlElement(name="attribute")
    private List<DetectorAttributeDTO> attributes = new ArrayList<DetectorAttributeDTO>();

    public DetectorResponseDTO() {
    }

    public DetectorResponseDTO(DetectResults results) {
        this.setDetected(results.isServiceDetected());
        if (results.getServiceAttributes() != null) {
            this.addAttributes(results.getServiceAttributes());
        }
    }

    public DetectorResponseDTO(Throwable t) {
        this.setDetected(false);
        this.setFailureMesage(t.getMessage());
    }

    public boolean isDetected() {
        return this.detected;
    }

    public void setDetected(boolean detected) {
        this.detected = detected;
    }

    public String getFailureMesage() {
        return this.failureMesage;
    }

    public void setFailureMesage(String failureMesage) {
        this.failureMesage = failureMesage;
    }

    public List<DetectorAttributeDTO> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String key, String value) {
        this.attributes.add(new DetectorAttributeDTO(key, value));
    }

    public void addAttributes(Map<String, String> attributes) {
        attributes.entrySet().stream().forEach(e -> this.addAttribute((String)e.getKey(), (String)e.getValue()));
    }

    public Map<String, String> getAttributesMap() {
        return this.attributes.stream().collect(Collectors.toMap(DetectorAttributeDTO::getKey, DetectorAttributeDTO::getValue));
    }

    public boolean isServiceDetected() {
        return this.detected;
    }

    public Map<String, String> getServiceAttributes() {
        return this.getAttributesMap();
    }

    public int hashCode() {
        return Objects.hash(this.detected, this.failureMesage, this.attributes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DetectorResponseDTO other = (DetectorResponseDTO)obj;
        return Objects.equals(this.detected, other.detected) && Objects.equals(this.failureMesage, other.failureMesage) && Objects.equals(this.attributes, other.attributes);
    }
}

