/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.client.rpc;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.DetectResults;
import org.opennms.netmgt.provision.DetectorRequestBuilder;
import org.opennms.netmgt.provision.ServiceDetector;
import org.opennms.netmgt.provision.ServiceDetectorFactory;
import org.opennms.netmgt.provision.detector.client.rpc.DetectorRequestDTO;
import org.opennms.netmgt.provision.detector.client.rpc.LocationAwareDetectorClientRpcImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectorRequestBuilderImpl
implements DetectorRequestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DetectorRequestBuilderImpl.class);
    private static final String PORT = "port";
    private String location;
    private String className;
    private InetAddress address;
    private Integer nodeId;
    private Map<String, String> attributes = new HashMap<String, String>();
    private final LocationAwareDetectorClientRpcImpl client;

    public DetectorRequestBuilderImpl(LocationAwareDetectorClientRpcImpl client) {
        this.client = client;
    }

    public DetectorRequestBuilder withLocation(String location) {
        this.location = location;
        return this;
    }

    public DetectorRequestBuilder withClassName(String className) {
        this.className = className;
        return this;
    }

    public DetectorRequestBuilder withServiceName(String serviceName) {
        ServiceDetector detector = this.client.getRegistry().getDetectorByServiceName(serviceName);
        if (detector == null) {
            throw new IllegalArgumentException("No detector found with service name '" + serviceName + "'.");
        }
        this.className = detector.getClass().getCanonicalName();
        return this;
    }

    public DetectorRequestBuilder withAddress(InetAddress address) {
        this.address = address;
        return this;
    }

    public DetectorRequestBuilder withAttributes(Map<String, String> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public DetectorRequestBuilder withAttribute(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    public DetectorRequestBuilder withNodeId(Integer nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public CompletableFuture<Boolean> execute() {
        if (this.address == null) {
            throw new IllegalArgumentException("Address is required.");
        }
        if (this.className == null) {
            throw new IllegalArgumentException("Detector class name is required.");
        }
        ServiceDetectorFactory factory = this.client.getRegistry().getDetectorFactoryByClassName(this.className);
        if (factory == null) {
            throw new IllegalArgumentException("No factory found for detector with class name '" + this.className + "'.");
        }
        DetectorRequestDTO detectorRequestDTO = new DetectorRequestDTO();
        detectorRequestDTO.setLocation(this.location);
        detectorRequestDTO.setClassName(this.className);
        detectorRequestDTO.setAddress(this.address);
        detectorRequestDTO.addDetectorAttributes(this.attributes);
        Integer port = null;
        String portString = this.attributes.get(PORT);
        if (portString != null) {
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Failed to parse port as integer from: ", (Object)portString);
            }
        }
        DetectRequest request = factory.buildRequest(this.location, this.address, port);
        detectorRequestDTO.addRuntimeAttributes(request.getRuntimeAttributes());
        return ((CompletableFuture)this.client.getDelegate().execute((RpcRequest)detectorRequestDTO).thenApply(results -> {
            if (results.getFailureMesage() != null) {
                try {
                    factory.afterDetect(request, (DetectResults)results, this.nodeId);
                }
                catch (Throwable t) {
                    LOG.error("Error while processing detect callback.", t);
                }
            }
            return results;
        })).thenApply(results -> {
            if (results.getFailureMesage() != null) {
                throw new RuntimeException(results.getFailureMesage());
            }
            return results.isDetected();
        });
    }
}

