/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.web.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.netmgt.provision.detector.web.request.WebRequest;
import org.opennms.netmgt.provision.detector.web.response.WebResponse;
import org.opennms.netmgt.provision.support.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebClient
implements Client<WebRequest, WebResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(WebClient.class);
    private HttpClientWrapper m_httpClientWrapper = null;
    private HttpGet m_httpMethod;
    private HttpVersion m_version = HttpVersion.HTTP_1_1;
    private String m_schema;
    private String m_path;
    private String m_queryString;
    private String m_userAgent;
    private String m_virtualHost;
    private String m_userName;
    private String m_password;
    private boolean m_overrideSSL = false;
    private boolean m_authPreemptive = false;

    public WebClient(boolean override) {
        this.m_overrideSSL = override;
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        List params;
        URIBuilder ub = new URIBuilder();
        ub.setScheme(this.m_schema);
        ub.setHost(InetAddressUtils.str((InetAddress)address));
        ub.setPort(port);
        ub.setPath(this.m_path);
        if (this.m_queryString != null && this.m_queryString.trim().length() > 0 && !(params = URLEncodedUtils.parse((String)this.m_queryString, (Charset)Charset.forName("UTF-8"))).isEmpty()) {
            ub.setParameters(params);
        }
        this.m_httpMethod = new HttpGet(ub.build());
        this.m_httpMethod.setProtocolVersion((ProtocolVersion)this.m_version);
        this.m_httpClientWrapper = HttpClientWrapper.create();
        if (this.m_overrideSSL) {
            try {
                this.m_httpClientWrapper.trustSelfSigned("https");
            }
            catch (Exception e) {
                LOG.warn("Failed to create relaxed SSL client.", (Throwable)e);
            }
        }
        if (this.m_userAgent != null && !this.m_userAgent.trim().isEmpty()) {
            this.m_httpClientWrapper.setUserAgent(this.m_userAgent);
        }
        if (timeout > 0) {
            this.m_httpClientWrapper.setConnectionTimeout(Integer.valueOf(timeout));
            this.m_httpClientWrapper.setSocketTimeout(Integer.valueOf(timeout));
        }
        if (this.m_virtualHost != null && !this.m_virtualHost.trim().isEmpty()) {
            this.m_httpClientWrapper.setVirtualHost(this.m_virtualHost);
        }
        if (this.m_userName != null && !this.m_userName.trim().isEmpty()) {
            this.m_httpClientWrapper.addBasicCredentials(this.m_userName, this.m_password);
        }
        if (this.m_authPreemptive) {
            this.m_httpClientWrapper.usePreemptiveAuth();
        }
    }

    public void close() {
        IOUtils.closeQuietly((Closeable)this.m_httpClientWrapper);
        this.m_httpClientWrapper = null;
    }

    public WebResponse receiveBanner() throws IOException, Exception {
        return null;
    }

    public WebResponse sendRequest(WebRequest request) throws IOException, Exception {
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            this.m_httpMethod.addHeader(entry.getKey(), entry.getValue());
        }
        CloseableHttpResponse response = null;
        try {
            response = this.m_httpClientWrapper.execute((HttpUriRequest)this.m_httpMethod);
            return new WebResponse(request, (HttpResponse)response);
        }
        catch (Exception e) {
            LOG.info(e.getMessage(), (Throwable)e);
            return new WebResponse(request, null);
        }
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public void setQueryString(String queryString) {
        this.m_queryString = queryString;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    public void setUserAgent(String userAgent) {
        this.m_userAgent = userAgent;
    }

    public void setVirtualHost(String virtualHost) {
        this.m_virtualHost = virtualHost;
    }

    public void setUseHttpV1(boolean useHttpV1) {
        if (useHttpV1) {
            this.m_version = HttpVersion.HTTP_1_0;
        }
    }

    public void setAuth(String userName, String password) {
        LOG.debug("enabling user authentication using credentials for {}", (Object)userName);
        this.m_userName = userName;
        this.m_password = password;
    }

    public void setAuthPreemtive(boolean authPreemtive) {
        this.m_authPreemptive = authPreemtive;
    }
}

