/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.web;

import org.opennms.netmgt.provision.detector.web.client.WebClient;
import org.opennms.netmgt.provision.detector.web.request.WebRequest;
import org.opennms.netmgt.provision.detector.web.response.WebResponse;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ResponseValidator;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class WebDetector
extends BasicDetector<WebRequest, WebResponse> {
    private static final String DEFAULT_SERVICE_NAME = "WEB";
    private static final int DEFAULT_PORT = 80;
    private String path = "/";
    private String userAgent = "OpenNMS WebMonitor";
    private String virtualHost;
    private boolean useHttpV1 = false;
    private String headers;
    private boolean authEnabled = false;
    private boolean authPreemtive = true;
    private String authUser = "admin";
    private String authPassword = "admin";
    private String responseText;
    private String responseRange = "100-399";
    private String schema = "http";
    private String queryString;
    private boolean useSSLFilter = false;

    public WebDetector() {
        super(DEFAULT_SERVICE_NAME, 80);
    }

    public WebDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    protected void onInit() {
        this.send(this.getRequest(), WebDetector.getWebValidator());
    }

    private WebRequest getRequest() {
        WebRequest request = new WebRequest();
        request.parseHeaders(this.getHeaders());
        request.setResponseRange(this.getResponseRange());
        request.setResponseText(this.getResponseText());
        return request;
    }

    private static ResponseValidator<WebResponse> getWebValidator() {
        return new ResponseValidator<WebResponse>(){

            public boolean validate(WebResponse pack) {
                return pack.isValid();
            }
        };
    }

    protected Client<WebRequest, WebResponse> getClient() {
        WebClient client = new WebClient(this.isUseSSLFilter());
        client.setPath(this.getPath());
        client.setSchema(this.getSchema());
        client.setUserAgent(this.getUserAgent());
        client.setVirtualHost(this.getVirtualHost());
        client.setQueryString(this.getQueryString());
        client.setUseHttpV1(this.isUseHttpV1());
        if (this.isAuthEnabled()) {
            client.setAuth(this.getAuthUser(), this.getAuthPassword());
            client.setAuthPreemtive(this.isAuthPreemtive());
        }
        return client;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public boolean isUseSSLFilter() {
        return this.useSSLFilter;
    }

    public void setUseSSLFilter(boolean useSSLFilter) {
        this.useSSLFilter = useSSLFilter;
    }

    public boolean isUseHttpV1() {
        return this.useHttpV1;
    }

    public void setUseHttpV1(boolean useHttpV1) {
        this.useHttpV1 = useHttpV1;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public void setAuthEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
    }

    public boolean isAuthPreemtive() {
        return this.authPreemtive;
    }

    public void setAuthPreemtive(boolean authPreemtive) {
        this.authPreemtive = authPreemtive;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public void setAuthUser(String authUser) {
        this.authUser = authUser;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public String getResponseText() {
        return this.responseText;
    }

    public void setResponseText(String responseText) {
        this.responseText = responseText;
    }

    public String getResponseRange() {
        return this.responseRange;
    }

    public void setResponseRange(String responseRange) {
        this.responseRange = responseRange;
    }
}

