/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.web.client;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.detector.web.request.WebRequest;
import org.opennms.netmgt.provision.detector.web.response.WebResponse;
import org.opennms.netmgt.provision.support.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebClient
implements Client<WebRequest, WebResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(WebClient.class);
    private DefaultHttpClient m_httpClient;
    private HttpGet m_httpMethod;
    private String schema;
    private String path;
    private String queryString;

    public WebClient(boolean override) {
        if (override) {
            this.m_httpClient = new DefaultHttpClient();
            try {
                this.m_httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory((TrustStrategy)new TrustSelfSignedStrategy(), (X509HostnameVerifier)new AllowAllHostnameVerifier())));
            }
            catch (Exception exception) {}
        } else {
            this.m_httpClient = new DefaultHttpClient();
        }
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        URIBuilder ub = new URIBuilder();
        ub.setScheme(this.schema);
        ub.setHost(InetAddressUtils.str((InetAddress)address));
        ub.setPort(port);
        ub.setPath(this.path);
        if (this.queryString != null) {
            ub.setQuery(this.queryString);
        }
        this.m_httpMethod = new HttpGet(ub.build());
        this.setTimeout(timeout);
    }

    public void close() {
        this.m_httpClient.getConnectionManager().shutdown();
    }

    public WebResponse receiveBanner() throws IOException, Exception {
        return null;
    }

    public WebResponse sendRequest(WebRequest request) throws IOException, Exception {
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            this.m_httpMethod.addHeader(entry.getKey(), entry.getValue());
        }
        try {
            CloseableHttpResponse response = this.m_httpClient.execute((HttpUriRequest)this.m_httpMethod);
            return new WebResponse(request, (HttpResponse)response);
        }
        catch (Exception e) {
            LOG.info(e.getMessage(), (Throwable)e);
            return new WebResponse(request, null);
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setUseSSLFilter(boolean sslFilter) {
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTimeout(int timeout) {
        if (timeout > 0) {
            this.m_httpClient.getParams().setParameter("http.connection.timeout", (Object)timeout);
            this.m_httpClient.getParams().setParameter("http.socket.timeout", (Object)timeout);
        }
    }

    public void setUserAgent(String userAgent) {
        this.m_httpClient.getParams().setParameter("http.useragent", (Object)userAgent);
    }

    public void setVirtualHost(String virtualHost, int virtualPort) {
        if (virtualHost == null || virtualPort == 0) {
            return;
        }
        this.m_httpClient.getParams().setParameter("http.virtual-host", (Object)new HttpHost(virtualHost, virtualPort));
    }

    public void setUseHttpV1(boolean useHttpV1) {
        if (useHttpV1) {
            this.m_httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
        }
    }

    public void setAuth(String userName, String password) {
        LOG.debug("enabling user authentication using credentials for {}", (Object)userName);
        this.m_httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
    }

    public void setAuthPreemtive(boolean authPreemtive) {
        HttpRequestInterceptor preemptiveAuth = new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws IOException {
                AuthScope authScope;
                Credentials creds;
                AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authState.getAuthScheme() == null && (creds = credsProvider.getCredentials(authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                    authState.update((AuthScheme)new BasicScheme(), creds);
                }
            }
        };
        this.m_httpClient.addRequestInterceptor(preemptiveAuth, 0);
    }
}

