/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.web.client;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.detector.web.request.WebRequest;
import org.opennms.netmgt.provision.detector.web.response.WebResponse;
import org.opennms.netmgt.provision.support.Client;

public class WebClient
implements Client<WebRequest, WebResponse> {
    private DefaultHttpClient m_httpClient = new DefaultHttpClient();
    private HttpGet m_httpMethod;
    private String schema;
    private String path;

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        URIBuilder ub = new URIBuilder();
        ub.setScheme(this.schema);
        ub.setHost(InetAddressUtils.str((InetAddress)address));
        ub.setPort(port);
        ub.setPath(this.path);
        this.m_httpMethod = new HttpGet(ub.build());
        this.setTimeout(timeout);
    }

    public void close() {
        this.m_httpClient.getConnectionManager().shutdown();
    }

    public WebResponse receiveBanner() throws IOException, Exception {
        return null;
    }

    public WebResponse sendRequest(WebRequest request) throws IOException, Exception {
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            this.m_httpMethod.addHeader(entry.getKey(), entry.getValue());
        }
        try {
            HttpResponse response = this.m_httpClient.execute((HttpUriRequest)this.m_httpMethod);
            return new WebResponse(request, response);
        }
        catch (Exception e) {
            this.log().info(e.getMessage(), (Throwable)e);
            return new WebResponse(request, null);
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTimeout(int timeout) {
        if (timeout > 0) {
            this.m_httpClient.getParams().setParameter("http.connection.timeout", (Object)timeout);
            this.m_httpClient.getParams().setParameter("http.socket.timeout", (Object)timeout);
        }
    }

    public void setUserAgent(String userAgent) {
        this.m_httpClient.getParams().setParameter("http.useragent", (Object)userAgent);
    }

    public void setVirtualHost(String virtualHost, int virtualPort) {
        if (virtualHost == null || virtualPort == 0) {
            return;
        }
        this.m_httpClient.getParams().setParameter("http.virtual-host", (Object)new HttpHost(virtualHost, virtualPort));
    }

    public void setUseHttpV1(boolean useHttpV1) {
        if (useHttpV1) {
            this.m_httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
        }
    }

    public void setAuth(String userName, String password) {
        this.log().debug("enabling user authentication using credentials for " + userName);
        this.m_httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
    }

    public void setAuthPreemtive(boolean authPreemtive) {
        HttpRequestInterceptor preemptiveAuth = new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws IOException {
                AuthScope authScope;
                Credentials creds;
                AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authState.getAuthScheme() == null && (creds = credsProvider.getCredentials(authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                    authState.update((AuthScheme)new BasicScheme(), creds);
                }
            }
        };
        this.m_httpClient.addRequestInterceptor(preemptiveAuth, 0);
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

