/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.web.response;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.detector.web.request.WebRequest;

public class WebResponse {
    private String expectedRange;
    private String expectedText;
    private HttpResponse httpResponse;

    public WebResponse(WebRequest request, HttpResponse response) {
        if (request != null) {
            this.expectedRange = request.getResponseRange();
            this.expectedText = request.getResponseText();
        }
        this.httpResponse = response;
    }

    public boolean isValid() {
        if (this.httpResponse == null || this.expectedRange == null) {
            return false;
        }
        Integer statusCode = this.httpResponse.getStatusLine().getStatusCode();
        this.log().debug("HTTP response status code: " + statusCode);
        boolean retval = this.inRange(this.expectedRange, statusCode);
        if (this.expectedText != null) {
            try {
                String responseText = EntityUtils.toString((HttpEntity)this.httpResponse.getEntity());
                this.log().debug("HTTP response text: " + responseText);
                this.log().debug("HTTP checking if output matches " + this.expectedText);
                if (this.expectedText.charAt(0) == '~') {
                    Pattern p = Pattern.compile(this.expectedText.substring(1), 8);
                    Matcher m = p.matcher(responseText);
                    retval = m.find();
                } else {
                    retval = responseText.equals(this.expectedText);
                }
            }
            catch (Exception e) {
                this.log().info(e.getMessage(), (Throwable)e);
                retval = false;
            }
        }
        this.log().debug("HTTP detected ? " + retval);
        return retval;
    }

    private boolean inRange(String range, Integer val) {
        String[] boundries = range.split("-");
        return val >= new Integer(boundries[0]) && val <= new Integer(boundries[1]);
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

