/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.snmp;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import org.opennms.netmgt.provision.detector.snmp.SnmpDetector;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BgpSessionDetector
extends SnmpDetector {
    private static final Logger LOG = LoggerFactory.getLogger(BgpSessionDetector.class);
    private static final String PROTOCOL_NAME = "BGP_Session";
    private static final String BGP_PEER_STATE_OID = ".1.3.6.1.2.1.15.3.1.2";
    private String m_bgpPeerIp = "";

    public BgpSessionDetector() {
        this.setServiceName(PROTOCOL_NAME);
    }

    @Override
    public boolean isServiceDetected(InetAddress address) {
        try {
            String bgpPeerIp = this.getBgpPeerIp();
            SnmpAgentConfig agentConfig = this.getAgentConfigFactory().getAgentConfig(address);
            this.configureAgentPTR(agentConfig);
            this.configureAgentVersion(agentConfig);
            String bgpPeerState = BgpSessionDetector.getValue(agentConfig, ".1.3.6.1.2.1.15.3.1.2." + bgpPeerIp, this.isHex());
            LOG.debug("BgpSessionMonitor.capsd: bgpPeerState: {}", (Object)bgpPeerState);
            if (bgpPeerState != null && Integer.parseInt(bgpPeerState) >= 1 && Integer.parseInt(bgpPeerState) <= 6) {
                return true;
            }
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
        return false;
    }

    public void setBgpPeerIp(String bgpPeerIp) {
        this.m_bgpPeerIp = bgpPeerIp;
    }

    public String getBgpPeerIp() {
        return this.m_bgpPeerIp;
    }
}

