/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.smb;

import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.detector.smb.client.SmbClient;
import org.opennms.netmgt.provision.detector.smb.response.NbtAddressResponse;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ResponseValidator;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SmbDetector
extends BasicDetector<LineOrientedRequest, NbtAddressResponse> {
    private static final String DEFAULT_SERVICE_NAME = "SMB";
    private static final int DEFAULT_RETRIES = 0;
    private static final int DEFAULT_TIMEOUT = 1000;
    private static final int DEFAULT_PORT = 0;

    public SmbDetector() {
        super(DEFAULT_SERVICE_NAME, 0, 1000, 0);
    }

    public SmbDetector(String serviceName) {
        super(serviceName, 0, 1000, 0);
    }

    public SmbDetector(String serviceName, int timeout, int retries) {
        super(serviceName, 0, timeout, retries);
    }

    protected void onInit() {
        this.expectBanner(SmbDetector.validateAddressIsNotSame());
    }

    private static ResponseValidator<NbtAddressResponse> validateAddressIsNotSame() {
        return new ResponseValidator<NbtAddressResponse>(){

            public boolean validate(NbtAddressResponse response) {
                return response.validateAddressIsNotSame();
            }
        };
    }

    protected Client<LineOrientedRequest, NbtAddressResponse> getClient() {
        return new SmbClient();
    }
}

