/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.icmp;

import java.net.InetAddress;
import org.opennms.netmgt.icmp.PingerFactory;
import org.opennms.netmgt.provision.support.SyncAbstractDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class IcmpDetector
extends SyncAbstractDetector {
    private static final Logger LOG = LoggerFactory.getLogger(IcmpDetector.class);

    public IcmpDetector() {
        super("ICMP", -1);
        this.init();
    }

    public boolean isServiceDetected(InetAddress address) {
        LOG.debug("isServiceDetected: Testing ICMP based service for address: {}...", (Object)address);
        boolean found = false;
        try {
            for (int i = 0; i < this.getRetries() && !found; ++i) {
                Number retval = PingerFactory.getInstance().ping(address, (long)this.getTimeout(), this.getRetries());
                LOG.debug("isServiceDetected: Response time for address: {} is: {}.", (Object)address, (Object)retval);
                if (retval == null) continue;
                found = true;
            }
            LOG.info("isServiceDetected: ICMP based service for address: {} is detected: {}.", (Object)address, (Object)found);
        }
        catch (InterruptedException e) {
            LOG.info("isServiceDetected: ICMP based service for address: {} is detected: {}. Received an InterruptedException.", (Object)address, (Object)false);
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            LOG.info("isServiceDetected: ICMP based service for address: {} is detected: {}. Received an Exception {}.", new Object[]{address, false, e});
        }
        return found;
    }

    protected void onInit() {
        this.setTimeout(800);
        this.setRetries(2);
    }

    public void dispose() {
    }
}

