/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.snmp;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import org.opennms.netmgt.provision.detector.snmp.SnmpDetector;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OmsaStorageDetector
extends SnmpDetector {
    private static final Logger LOG = LoggerFactory.getLogger(OmsaStorageDetector.class);
    private static final String PROTOCOL_NAME = "OMSAStorage";
    private static final String virtualDiskRollUpStatus = ".1.3.6.1.4.1.674.10893.1.20.140.1.1.19";
    private String m_virtualDiskNumber = "1";

    public OmsaStorageDetector() {
        this.setServiceName(PROTOCOL_NAME);
    }

    @Override
    public boolean isServiceDetected(InetAddress address) {
        try {
            SnmpAgentConfig agentConfig = this.getAgentConfigFactory().getAgentConfig(address);
            this.configureAgentPTR(agentConfig);
            this.configureAgentVersion(agentConfig);
            SnmpObjId virtualDiskRollUpStatusSnmpObject = SnmpObjId.get((String)(".1.3.6.1.4.1.674.10893.1.20.140.1.1.19." + this.m_virtualDiskNumber));
            SnmpValue virtualDiskRollUpStatus = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)virtualDiskRollUpStatusSnmpObject);
            if (virtualDiskRollUpStatus == null || virtualDiskRollUpStatus.isNull()) {
                LOG.debug("SNMP poll failed: no results, addr={} oid={}", (Object)address, (Object)virtualDiskRollUpStatusSnmpObject);
                return false;
            }
            if (virtualDiskRollUpStatus.toInt() != 3) {
                LOG.debug("OMSAStorageMonitor.poll: Bad Disk Found. Log vol({}) degraded", (Object)this.m_virtualDiskNumber);
                return false;
            }
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
        return true;
    }

    public String getVirtualDiskNumber() {
        return this.m_virtualDiskNumber;
    }

    public void setVirtualDiskNumber(String virtualDiskNumber) {
        this.m_virtualDiskNumber = virtualDiskNumber;
    }
}

