/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.snmp;

import antlr.StringUtils;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.detector.snmp.SnmpDetector;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class HostResourceSWRunDetector
extends SnmpDetector {
    private static final Logger LOG = LoggerFactory.getLogger(HostResourceSWRunDetector.class);
    private static final String PROTOCOL_NAME = "HOST-RESOURCES";
    private static final String HOSTRESOURCE_SW_NAME_OID = ".1.3.6.1.2.1.25.4.2.1.2";
    static final String SNMP_AGENTCONFIG_KEY = "org.opennms.netmgt.snmp.SnmpAgentConfig";
    private String m_serviceToDetect;
    private String m_serviceNameOid;

    public HostResourceSWRunDetector() {
        this.setServiceName(PROTOCOL_NAME);
        this.setServiceNameOid(HOSTRESOURCE_SW_NAME_OID);
    }

    @Override
    public boolean isServiceDetected(InetAddress address) {
        boolean status = false;
        SnmpAgentConfig agentConfig = this.getAgentConfigFactory().getAgentConfig(address);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + address);
        }
        String serviceName = this.getServiceToDetect();
        this.configureAgentPTR(agentConfig);
        LOG.debug("capsd: service= SNMP address={}", (Object)agentConfig);
        String hostAddress = InetAddressUtils.str((InetAddress)address);
        try {
            LOG.debug("HostResourceSwRunMonitor.poll: SnmpAgentConfig address: {}", (Object)agentConfig);
            if (serviceName == null) {
                LOG.warn("HostResourceSwRunMonitor.poll: No Service Name Defined! ");
                return status;
            }
            Map nameResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"HostResourceSwRunMonitor", (SnmpObjId)SnmpObjId.get((String)this.getServiceNameOid()));
            for (Map.Entry entry : nameResults.entrySet()) {
                SnmpValue value = (SnmpValue)entry.getValue();
                if (!this.match(serviceName, HostResourceSWRunDetector.stripExtraQuotes(value.toString())) || status) continue;
                LOG.debug("poll: HostResourceSwRunMonitor poll succeeded, addr={} service name={} value={}", new Object[]{hostAddress, serviceName, value});
                status = true;
                break;
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("Number operator used on a non-number {}", (Object)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid SNMP Criteria: {}", (Object)e.getMessage());
        }
        catch (Throwable t) {
            LOG.warn("Unexpected exception during SNMP poll of interface {}", (Object)hostAddress, (Object)t);
        }
        return status;
    }

    private boolean match(String expectedText, String currentText) {
        if (expectedText.startsWith("~")) {
            return currentText.matches(expectedText.replaceFirst("~", ""));
        }
        return currentText.equalsIgnoreCase(expectedText);
    }

    private static String stripExtraQuotes(String string) {
        return StringUtils.stripFrontBack((String)string, (String)"\"", (String)"\"");
    }

    public void setServiceNameOid(String serviceNameOid) {
        this.m_serviceNameOid = serviceNameOid;
    }

    public String getServiceNameOid() {
        return this.m_serviceNameOid;
    }

    public void setServiceToDetect(String hostService) {
        this.m_serviceToDetect = hostService;
    }

    public String getServiceToDetect() {
        return this.m_serviceToDetect;
    }
}

