/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.response;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.provision.detector.simple.response.MultilineOrientedResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultilineHttpResponse
extends MultilineOrientedResponse {
    private static final Logger LOG = LoggerFactory.getLogger(MultilineHttpResponse.class);
    private static final Pattern HTTP_RESPONSE_REGEX = Pattern.compile("([H][T][T][P+]/[1].[0-1]) ([0-9][0-9][0-9]) ([a-zA-Z ]+)\r?\n");

    public boolean validateResponse(String pattern, String url, boolean isCheckCode, int maxRetCode) throws Exception {
        String httpResponse = (String)this.getResponseList().toArray()[0];
        LOG.debug("HTTP Response: {}", (Object)httpResponse);
        Matcher m = HTTP_RESPONSE_REGEX.matcher(httpResponse);
        if (m.matches()) {
            if (isCheckCode) {
                int returnCode = Integer.valueOf(m.group(2));
                LOG.debug("return code = {}, max return code = {}", (Object)returnCode, (Object)maxRetCode);
                return returnCode <= maxRetCode;
            }
            return true;
        }
        LOG.debug("does not match");
        return false;
    }

    @Override
    public String toString() {
        return this.getResponseList().isEmpty() ? "MultilineHttpResponse" : String.format("Response: %s", this.getResponseListAsString(this.getResponseList().toArray()));
    }

    private String getResponseListAsString(Object[] array) {
        StringBuffer retVal = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            retVal.append((String)array[i]);
        }
        return retVal.toString();
    }
}

